/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.report.html.doc.Attribute;
import com.vladium.emma.report.html.doc.HTMLWriter;
import com.vladium.emma.report.html.doc.IContent;
import com.vladium.util.Strings;
import java.util.HashMap;
import java.util.Map;

public abstract class AttributeSet
implements IContent {
    public static AttributeSet create() {
        return new AttributeSetImpl();
    }

    public abstract boolean isEmpty();

    public abstract AttributeSet set(Attribute var1, String var2);

    public abstract AttributeSet set(Attribute var1, int var2);

    AttributeSet() {
    }

    private static final class AttributeSetImpl
    extends AttributeSet {
        private final Map m_attrMap = new HashMap();
        private StringBuffer m_buf;
        private static final int MAX_BUF_LENGTH = 4096;

        public void emit(HTMLWriter hTMLWriter) {
            boolean bl = true;
            for (Map.Entry entry : this.m_attrMap.entrySet()) {
                Attribute attribute = (Attribute)entry.getKey();
                String string = entry.getValue().toString();
                if (bl) {
                    bl = false;
                } else {
                    hTMLWriter.write(' ');
                }
                hTMLWriter.write(attribute.getName());
                hTMLWriter.write("=\"");
                if (this.m_buf != null && this.m_buf.length() <= 4096) {
                    this.m_buf.setLength(0);
                } else {
                    this.m_buf = new StringBuffer();
                }
                Strings.HTMLEscape(string, this.m_buf);
                hTMLWriter.write(this.m_buf.toString());
                hTMLWriter.write('\"');
            }
        }

        public boolean isEmpty() {
            return this.m_attrMap.isEmpty();
        }

        public AttributeSet set(Attribute attribute, String string) {
            this.m_attrMap.put(attribute, string);
            return this;
        }

        public AttributeSet set(Attribute attribute, int n) {
            this.m_attrMap.put(attribute, new Integer(n));
            return this;
        }

        AttributeSetImpl() {
        }
    }
}

