/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.List;
import java.util.Set;
import lombok.ast.libs.org.parboiled.google.collect.Lists;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class InvalidPackageDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("InvalidPackage", "Package not included in Android", "Finds API accesses to APIs that are not supported in Android", "This check scans through libraries looking for calls to APIs that are not included in Android.\n\nWhen you create Android projects, the classpath is set up such that you can only access classes in the API packages that are included in Android. However, if you add other projects to your libs/ folder, there is no guarantee that those .jar files were built with an Android specific classpath, and in particular, they could be accessing unsupported APIs such as java.applet.\n\nThis check scans through library jars and looks for references to API packages that are not included in Android and flags these. This is only an error if your code calls one of the library classes which wind up referencing the unsupported package.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(InvalidPackageDetector.class, Scope.JAVA_LIBRARY_SCOPE));
    private static final String JAVA_PKG_PREFIX = "java/";
    private static final String JAVAX_PKG_PREFIX = "javax/";
    private ApiLookup mApiDatabase;
    private List<Candidate> mCandidates;
    private final Set<String> mJavaxLibraryClasses = Sets.newHashSetWithExpectedSize((int)64);

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.SLOW;
    }

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        this.mApiDatabase = ApiLookup.get(context.getClient());
    }

    @Override
    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (!context.isFromClassLibrary() || InvalidPackageDetector.shouldSkip(context.file)) {
            return;
        }
        if (this.mApiDatabase == null) {
            return;
        }
        if (classNode.name.startsWith(JAVAX_PKG_PREFIX)) {
            this.mJavaxLibraryClasses.add(classNode.name);
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            String type;
            int args;
            MethodNode method = (MethodNode)m;
            InsnList nodes = method.instructions;
            String signature = method.desc;
            if (signature != null && (args = signature.indexOf(41)) != -1 && signature.charAt(args + 1) == 'L' && this.isInvalidPackage(type = signature.substring(args + 2, signature.length() - 1))) {
                AbstractInsnNode first = nodes.size() > 0 ? nodes.get(0) : null;
                this.record(context, method, first, type);
            }
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                Type t;
                String className;
                String owner;
                MethodInsnNode node;
                AbstractInsnNode instruction = nodes.get(i);
                int type2 = instruction.getType();
                if (type2 == 5) {
                    node = (MethodInsnNode)instruction;
                    owner = node.owner;
                    if (node.getOpcode() == 182 && owner.equals(classNode.name)) {
                        owner = classNode.superName;
                    }
                    while (owner != null) {
                        if (this.isInvalidPackage(owner)) {
                            this.record(context, method, instruction, owner);
                        }
                        if (owner.startsWith("android/") || owner.startsWith(JAVA_PKG_PREFIX) || owner.startsWith(JAVAX_PKG_PREFIX)) {
                            owner = null;
                            continue;
                        }
                        if (node.getOpcode() == 182) {
                            owner = context.getDriver().getSuperClass(owner);
                            continue;
                        }
                        if (node.getOpcode() == 184) {
                            owner = context.getDriver().getSuperClass(owner);
                            continue;
                        }
                        owner = null;
                    }
                    continue;
                }
                if (type2 == 4) {
                    node = (FieldInsnNode)instruction;
                    owner = node.owner;
                    if (!this.isInvalidPackage(owner)) continue;
                    this.record(context, method, instruction, owner);
                    continue;
                }
                if (type2 != 9) continue;
                node = (LdcInsnNode)instruction;
                if (!(node.cst instanceof Type) || !this.isInvalidPackage(className = (t = (Type)node.cst).getInternalName())) continue;
                this.record(context, method, instruction, className);
            }
        }
    }

    private boolean isInvalidPackage(String owner) {
        if (owner.startsWith(JAVA_PKG_PREFIX) || owner.startsWith(JAVAX_PKG_PREFIX)) {
            return !this.mApiDatabase.isValidJavaPackage(owner);
        }
        return false;
    }

    private void record(ClassContext context, MethodNode method, AbstractInsnNode instruction, String owner) {
        if (owner.indexOf(36) != -1) {
            return;
        }
        if (this.mCandidates == null) {
            this.mCandidates = Lists.newArrayList();
        }
        this.mCandidates.add(new Candidate(owner, context.getClassNode().name, context.getJarFile()));
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (this.mCandidates == null) {
            return;
        }
        for (Candidate candidate : this.mCandidates) {
            String type = candidate.mClass;
            if (this.mJavaxLibraryClasses.contains(type)) continue;
            File jarFile = candidate.mJarFile;
            String referencedIn = candidate.mReferencedIn;
            Location location = Location.create(jarFile);
            Object pkg = InvalidPackageDetector.getPackageName(type);
            String message = String.format("Invalid package reference in library; not included in Android: %1$s. Referenced from %2$s.", pkg, ClassContext.getFqcn(referencedIn));
            context.report(ISSUE, location, message, null);
        }
    }

    private static Object getPackageName(String owner) {
        String pkg = owner;
        int index = pkg.lastIndexOf(47);
        if (index != -1) {
            pkg = pkg.substring(0, index);
        }
        return ClassContext.getFqcn(pkg);
    }

    private static boolean shouldSkip(File file) {
        return file.getPath().endsWith("android-support-v4.jar");
    }

    private static class Candidate {
        private final String mReferencedIn;
        private final File mJarFile;
        private final String mClass;

        public Candidate(String className, String referencedIn, File jarFile) {
            this.mClass = className;
            this.mReferencedIn = referencedIn;
            this.mJarFile = jarFile;
        }
    }
}

