/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class TextFieldDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("TextFields", "Missing `inputType` or `hint`", "Looks for text fields missing `inputType` or `hint` settings", "Providing an `inputType` attribute on a text field improves usability because depending on the data to be input, optimized keyboards can be shown to the user (such as just digits and parentheses for a phone number). Similarly,a hint attribute displays a hint to the user for what is expected in the text field.\n\nThe lint detector also looks at the `id` of the view, and if the id offers a hint of the purpose of the field (for example, the `id` contains the phrase `phone` or `email`), then lint will also ensure that the `inputType` contains the corresponding type attributes.\n\nIf you really want to keep the text field generic, you can suppress this warning by setting `inputType=\"text\"`.", Category.USABILITY, 5, Severity.WARNING, new Implementation(TextFieldDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("EditText");
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String message;
        Attr idNode;
        String style = element.getAttribute("style");
        if (style != null && !style.isEmpty()) {
            return;
        }
        Attr inputTypeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "inputType");
        if (inputTypeNode == null && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "inputMethod")) {
                return;
            }
            context.report(ISSUE, element, context.getLocation(element), "This text field does not specify an inputType or a hint", null);
        }
        if ((idNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "id")) == null) {
            return;
        }
        String id = idNode.getValue();
        if (id.isEmpty()) {
            return;
        }
        if (id.startsWith("editText")) {
            return;
        }
        String inputType = "";
        if (inputTypeNode != null) {
            inputType = inputTypeNode.getValue();
        }
        if (TextFieldDetector.containsWord(id, "phone", true, true)) {
            if (!inputType.contains("phone") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "phoneNumber") == null) {
                String message2 = String.format("The view name (%1$s) suggests this is a phone number, but it does not include 'phone' in the inputType", id);
                TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message2);
            }
            return;
        }
        if (TextFieldDetector.containsWord(id, "width", false, true) || TextFieldDetector.containsWord(id, "height", false, true) || TextFieldDetector.containsWord(id, "size", false, true) || TextFieldDetector.containsWord(id, "length", false, true) || TextFieldDetector.containsWord(id, "weight", false, true) || TextFieldDetector.containsWord(id, "number", false, true)) {
            if (!inputType.contains("number") && !inputType.contains("phone")) {
                String message3 = String.format("The view name (%1$s) suggests this is a number, but it does not include a numeric inputType (such as 'numberSigned')", id);
                TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message3);
            }
            return;
        }
        if (TextFieldDetector.containsWord(id, "password", true, true)) {
            if (!inputType.contains("Password") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "password") == null) {
                String message4 = String.format("The view name (%1$s) suggests this is a password, but it does not include 'textPassword' in the inputType", id);
                TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message4);
            }
            return;
        }
        if (TextFieldDetector.containsWord(id, "email", true, true)) {
            if (!inputType.contains("Email")) {
                String message5 = String.format("The view name (%1$s) suggests this is an e-mail address, but it does not include 'textEmail' in the inputType", id);
                TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message5);
            }
            return;
        }
        if (TextFieldDetector.endsWith(id, "pin", false, true)) {
            if (!inputType.contains("numberPassword") && element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "password") == null) {
                String message6 = String.format("The view name (%1$s) suggests this is a password, but it does not include 'numberPassword' in the inputType", id);
                TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message6);
            }
            return;
        }
        if ((TextFieldDetector.containsWord(id, "uri") || TextFieldDetector.containsWord(id, "url")) && !inputType.contains("textUri")) {
            message = String.format("The view name (%1$s) suggests this is a URI, but it does not include 'textUri' in the inputType", id);
            TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message);
        }
        if (TextFieldDetector.containsWord(id, "date") && !inputType.contains("date")) {
            message = String.format("The view name (%1$s) suggests this is a date, but it does not include 'date' or 'datetime' in the inputType", id);
            TextFieldDetector.reportMismatch(context, idNode, inputTypeNode, message);
        }
    }

    private static void reportMismatch(XmlContext context, Attr idNode, Attr inputTypeNode, String message) {
        Location location;
        if (inputTypeNode != null) {
            location = context.getLocation(inputTypeNode);
            Location secondary = context.getLocation(idNode);
            secondary.setMessage("id defined here");
            location.setSecondary(secondary);
        } else {
            location = context.getLocation(idNode);
        }
        context.report(ISSUE, idNode.getOwnerElement(), location, message, null);
    }

    static boolean containsWord(String sentence, String word) {
        return TextFieldDetector.containsWord(sentence, word, false, false);
    }

    static boolean containsWord(String sentence, String word, boolean allowPrefix, boolean allowSuffix) {
        return TextFieldDetector.indexOfWord(sentence, word, allowPrefix, allowSuffix) != -1;
    }

    private static boolean endsWith(String sentence, String word, boolean allowPrefix, boolean allowSuffix) {
        int index = TextFieldDetector.indexOfWord(sentence, word, allowPrefix, allowSuffix);
        if (index != -1) {
            return index == sentence.length() - word.length();
        }
        return false;
    }

    private static int indexOfWord(String sentence, String word, boolean allowPrefix, boolean allowSuffix) {
        if (sentence.isEmpty()) {
            return -1;
        }
        int wordLength = word.length();
        if (wordLength > sentence.length()) {
            return -1;
        }
        char firstUpper = Character.toUpperCase(word.charAt(0));
        char firstLower = Character.toLowerCase(firstUpper);
        int start = 0;
        if (sentence.startsWith("@+id/")) {
            start += "@+id/".length();
        } else if (sentence.startsWith("@id/")) {
            start += "@id/".length();
        }
        int n = sentence.length();
        int m = n - (wordLength - 1);
        for (int i = start; i < m; ++i) {
            char c = sentence.charAt(i);
            if (c != firstUpper && c != firstLower || !sentence.regionMatches(true, i, word, 0, wordLength)) continue;
            if (i <= start && allowPrefix) {
                return i;
            }
            if (i == m - 1 && allowSuffix) {
                return i;
            }
            if (i > start && sentence.charAt(i - 1) != '_' && !Character.isUpperCase(c)) continue;
            if (i == m - 1) {
                return i;
            }
            char after = sentence.charAt(i + wordLength);
            if (after != '_' && !Character.isUpperCase(after)) continue;
            return i;
        }
        return -1;
    }
}

