/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor.ddms;

import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StaticPortEditDialog
extends Dialog {
    private static final int DLG_WIDTH = 400;
    private static final int DLG_HEIGHT = 200;
    private Shell mParent;
    private Shell mShell;
    private boolean mOk = false;
    private String mAppName;
    private String mPortNumber;
    private Button mOkButton;
    private Label mWarning;
    private ArrayList<Integer> mPorts;
    private int mEditPort = -1;
    private String mDeviceSn;

    public StaticPortEditDialog(Shell shell, ArrayList<Integer> arrayList) {
        super(shell, 67680);
        this.mPorts = arrayList;
        this.mDeviceSn = "emulator-5554";
    }

    public StaticPortEditDialog(Shell shell, ArrayList<Integer> arrayList, String string, String string2, String string3) {
        this(shell, arrayList);
        this.mDeviceSn = string;
        this.mAppName = string2;
        this.mPortNumber = string3;
        this.mEditPort = Integer.valueOf(this.mPortNumber);
    }

    public boolean open() {
        this.createUI();
        if (this.mParent == null || this.mShell == null) {
            return false;
        }
        this.mShell.setMinimumSize(400, 200);
        Rectangle rectangle = this.mParent.getBounds();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = n - 200;
        int n3 = rectangle.y + rectangle.height / 2;
        int n4 = n3 - 100;
        this.mShell.setBounds(n2, n4, 400, 200);
        this.mShell.open();
        Display display = this.mParent.getDisplay();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.mOk;
    }

    public String getDeviceSN() {
        return this.mDeviceSn;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public int getPortNumber() {
        return Integer.valueOf(this.mPortNumber);
    }

    private void createUI() {
        this.mParent = this.getParent();
        this.mShell = new Shell(this.mParent, this.getStyle());
        this.mShell.setText("Static Port");
        this.mShell.setLayout((Layout)new GridLayout(1, false));
        this.mShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        Composite composite = new Composite((Composite)this.mShell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Device Name:");
        final Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(768));
        if (this.mDeviceSn != null) {
            text.setText(this.mDeviceSn);
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                StaticPortEditDialog.this.mDeviceSn = text.getText().trim();
                StaticPortEditDialog.this.validate();
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText("Application Name:");
        final Text text2 = new Text(composite, 2052);
        if (this.mAppName != null) {
            text2.setText(this.mAppName);
        }
        text2.setLayoutData((Object)new GridData(768));
        text2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                StaticPortEditDialog.this.mAppName = text2.getText().trim();
                StaticPortEditDialog.this.validate();
            }
        });
        Label label3 = new Label(composite, 0);
        label3.setText("Debug Port:");
        final Text text3 = new Text(composite, 2052);
        if (this.mPortNumber != null) {
            text3.setText(this.mPortNumber);
        }
        text3.setLayoutData((Object)new GridData(768));
        text3.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                StaticPortEditDialog.this.mPortNumber = text3.getText().trim();
                StaticPortEditDialog.this.validate();
            }
        });
        Composite composite2 = new Composite((Composite)this.mShell, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.mWarning = new Label(composite2, 0);
        this.mWarning.setText("");
        this.mWarning.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite((Composite)this.mShell, 0);
        composite3.setLayoutData((Object)new GridData(64));
        composite3.setLayout((Layout)new GridLayout(2, true));
        this.mOkButton = new Button(composite3, 0);
        this.mOkButton.setText("OK");
        this.mOkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StaticPortEditDialog.this.mOk = true;
                StaticPortEditDialog.this.mShell.close();
            }
        });
        this.mOkButton.setEnabled(false);
        this.mShell.setDefaultButton(this.mOkButton);
        Button button = new Button(composite3, 0);
        button.setText("Cancel");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StaticPortEditDialog.this.mShell.close();
            }
        });
        this.validate();
    }

    private void validate() {
        this.mWarning.setText("");
        if (this.mDeviceSn == null || this.mDeviceSn.length() == 0) {
            this.mWarning.setText("Device name missing.");
            this.mOkButton.setEnabled(false);
            return;
        }
        if (this.mAppName == null || this.mAppName.length() == 0) {
            this.mWarning.setText("Application name missing.");
            this.mOkButton.setEnabled(false);
            return;
        }
        String string = "Application name must be a valid Java package name.";
        String[] stringArray = this.mAppName.split("\\.");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            if (!string2.matches("^[a-zA-Z][a-zA-Z0-9]*")) {
                this.mWarning.setText(string);
                this.mOkButton.setEnabled(false);
                return;
            }
            if (!string2.matches("^[a-z][a-z0-9]*")) {
                this.mWarning.setText("Lower case is recommended for Java packages.");
            }
            ++n2;
        }
        if (this.mAppName.charAt(this.mAppName.length() - 1) == '.') {
            this.mWarning.setText(string);
            this.mOkButton.setEnabled(false);
            return;
        }
        if (this.mPortNumber == null || this.mPortNumber.length() == 0) {
            this.mWarning.setText("Port Number missing.");
            this.mOkButton.setEnabled(false);
            return;
        }
        if (!this.mPortNumber.matches("[0-9]*")) {
            this.mWarning.setText("Port Number invalid.");
            this.mOkButton.setEnabled(false);
            return;
        }
        long l = Long.valueOf(this.mPortNumber);
        if (l >= 32767L) {
            this.mOkButton.setEnabled(false);
            return;
        }
        if (l != (long)this.mEditPort) {
            for (Integer n3 : this.mPorts) {
                if (l != (long)n3.intValue()) continue;
                this.mWarning.setText("Port already in use.");
                this.mOkButton.setEnabled(false);
                return;
            }
        }
        this.mOkButton.setEnabled(true);
    }
}

