/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GlTracePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.android.ide.eclipse.gldebugger";
    private static GlTracePlugin plugin;
    private MessageConsole mConsole;
    private MessageConsoleStream mConsoleStream;
    private static Runnable sShowConsoleRunnable;

    static {
        sShowConsoleRunnable = new Runnable(){

            @Override
            public void run() {
                GlTracePlugin.showConsoleView();
            }
        };
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        this.mConsole = new MessageConsole("OpenGL Trace View", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.mConsole});
        this.mConsoleStream = this.mConsole.newMessageStream();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static GlTracePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return GlTracePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
    }

    public void logMessage(String string) {
        this.mConsoleStream.println(string);
        Display.getDefault().asyncExec(sShowConsoleRunnable);
    }

    private static void showConsoleView() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
            try {
                iWorkbenchPage.showView("org.eclipse.ui.console.ConsoleView", null, 2);
            }
            catch (PartInitException partInitException) {}
        }
    }
}

