/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DurationMinimap
extends Canvas {
    private static final int DEFAULT_ALPHA = 255;
    private static final int VISIBLE_CALLS_HIGHLIGHT_ALPHA = 50;
    private static final long CALL_DURATION_CLAMP = 20000L;
    private static final String FONT_KEY = "default.font";
    private static final int MAX_DURATION_LENGTH_SCALE = 6;
    private List<GLCall> mCalls;
    private int mContextCount;
    private int mStartCallIndex;
    private int mEndCallIndex;
    private int mVisibleCallTopIndex;
    private int mVisibleCallBottomIndex;
    private Color mBackgroundColor;
    private Color mDurationLineColor;
    private Color mGlDrawColor;
    private Color mGlErrorColor;
    private Color mContextHeaderColor;
    private Color mVisibleCallsHighlightColor;
    private Color mMouseMarkerColor;
    private FontRegistry mFontRegistry;
    private int mFontWidth;
    private int mFontHeight;
    private Image mBackBufferImage;
    private GC mBackBufferGC;
    private boolean mMouseInSelf;
    private int mMouseY;
    private final PositionHelper mPositionHelper;
    private List<ICallSelectionListener> mListeners = new ArrayList<ICallSelectionListener>();

    public DurationMinimap(Composite composite, GLTrace gLTrace) {
        super(composite, 262144);
        this.setInput(gLTrace);
        this.initializeColors();
        this.initializeFonts();
        this.mPositionHelper = new PositionHelper(this.mFontHeight, this.mContextCount, this.mFontWidth * 6, 20000L);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                DurationMinimap.this.draw(paintEvent.display, paintEvent.gc);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DurationMinimap.this.controlResized();
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                DurationMinimap.this.mouseMoved(mouseEvent);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                DurationMinimap.this.mouseClicked(mouseEvent);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent mouseEvent) {
            }

            public void mouseExit(MouseEvent mouseEvent) {
                DurationMinimap.this.mMouseInSelf = false;
                DurationMinimap.this.redraw();
            }

            public void mouseEnter(MouseEvent mouseEvent) {
                DurationMinimap.this.mMouseInSelf = true;
                DurationMinimap.this.redraw();
            }
        });
    }

    public void setInput(GLTrace gLTrace) {
        if (gLTrace != null) {
            this.mCalls = gLTrace.getGLCalls();
            this.mContextCount = gLTrace.getContexts().size();
        } else {
            this.mCalls = null;
            this.mContextCount = 1;
        }
    }

    public void dispose() {
        this.disposeColors();
        this.disposeBackBuffer();
        super.dispose();
    }

    private void initializeColors() {
        this.mBackgroundColor = new Color((Device)this.getDisplay(), 51, 51, 51);
        this.mDurationLineColor = new Color((Device)this.getDisplay(), 8, 81, 156);
        this.mGlDrawColor = new Color((Device)this.getDisplay(), 107, 174, 214);
        this.mContextHeaderColor = new Color((Device)this.getDisplay(), 209, 229, 240);
        this.mVisibleCallsHighlightColor = new Color((Device)this.getDisplay(), 204, 204, 204);
        this.mMouseMarkerColor = new Color((Device)this.getDisplay(), 170, 170, 170);
        this.mGlErrorColor = this.getDisplay().getSystemColor(3);
    }

    private void disposeColors() {
        this.mBackgroundColor.dispose();
        this.mDurationLineColor.dispose();
        this.mGlDrawColor.dispose();
        this.mContextHeaderColor.dispose();
        this.mVisibleCallsHighlightColor.dispose();
        this.mMouseMarkerColor.dispose();
    }

    private void initializeFonts() {
        this.mFontRegistry = new FontRegistry(this.getDisplay());
        this.mFontRegistry.put(FONT_KEY, new FontData[]{new FontData("Arial", 8, 0)});
        GC gC = new GC((Drawable)this.getDisplay());
        gC.setFont(this.mFontRegistry.get(FONT_KEY));
        this.mFontWidth = gC.getFontMetrics().getAverageCharWidth();
        this.mFontHeight = gC.getFontMetrics().getHeight();
        gC.dispose();
    }

    private void initializeBackBuffer() {
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            this.mBackBufferImage = null;
            this.mBackBufferGC = null;
            return;
        }
        this.mBackBufferImage = new Image((Device)this.getDisplay(), rectangle.width, rectangle.height);
        this.mBackBufferGC = new GC((Drawable)this.mBackBufferImage);
    }

    private void disposeBackBuffer() {
        if (this.mBackBufferImage != null) {
            this.mBackBufferImage.dispose();
            this.mBackBufferImage = null;
        }
        if (this.mBackBufferGC != null) {
            this.mBackBufferGC.dispose();
            this.mBackBufferGC = null;
        }
    }

    private void mouseMoved(MouseEvent mouseEvent) {
        this.mMouseY = mouseEvent.y;
        this.redraw();
    }

    private void mouseClicked(MouseEvent mouseEvent) {
        if (this.mMouseInSelf) {
            int n = this.mPositionHelper.getCallAt(this.mMouseY);
            this.sendCallSelectedEvent(n);
            this.redraw();
        }
    }

    private void draw(Display display, GC gC) {
        if (this.mBackBufferImage == null) {
            this.initializeBackBuffer();
        }
        if (this.mBackBufferImage == null) {
            return;
        }
        this.drawBackground(this.mBackBufferGC, this.mBackBufferImage.getBounds());
        this.drawContextHeaders(this.mBackBufferGC);
        this.drawCallDurations(this.mBackBufferGC);
        this.drawVisibleCallHighlights(this.mBackBufferGC);
        this.drawMouseMarkers(this.mBackBufferGC);
        int n = this.getClientArea().width;
        int n2 = this.getClientArea().height;
        gC.drawImage(this.mBackBufferImage, 0, 0, n, n2, 0, 0, n, n2);
    }

    private void drawBackground(GC gC, Rectangle rectangle) {
        gC.setBackground(this.mBackgroundColor);
        gC.fillRectangle(rectangle);
    }

    private void drawContextHeaders(GC gC) {
        if (this.mContextCount <= 1) {
            return;
        }
        gC.setForeground(this.mContextHeaderColor);
        gC.setFont(this.mFontRegistry.get(FONT_KEY));
        int n = 0;
        while (n < this.mContextCount) {
            Point point = this.mPositionHelper.getHeaderLocation(n);
            gC.drawText("CTX" + Integer.toString(n), point.x, point.y);
            ++n;
        }
    }

    private void drawCallDurations(GC gC) {
        if (this.mCalls == null || this.mCalls.size() < this.mEndCallIndex) {
            return;
        }
        gC.setBackground(this.mDurationLineColor);
        int n = this.mPositionHelper.getCallUnderScanValue();
        int n2 = this.mStartCallIndex;
        while (n2 < this.mEndCallIndex) {
            boolean bl = false;
            GLCall gLCall = this.mCalls.get(n2);
            long l = gLCall.getWallDuration();
            if (gLCall.hasErrors()) {
                gC.setBackground(this.mGlErrorColor);
                bl = true;
                l = this.mPositionHelper.getMaxDuration();
            } else if (gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glDrawArrays || gLCall.getFunction() == GLProtoBuf.GLMessage.Function.glDrawElements || gLCall.getFunction() == GLProtoBuf.GLMessage.Function.eglSwapBuffers) {
                gC.setBackground(this.mGlDrawColor);
                bl = true;
                l = this.mPositionHelper.getMaxDuration();
            }
            Rectangle rectangle = this.mPositionHelper.getDurationBounds(n2 - this.mStartCallIndex, gLCall.getContextId(), l);
            gC.fillRectangle(rectangle);
            if (bl) {
                gC.setBackground(this.mDurationLineColor);
            }
            n2 += n;
        }
    }

    private void drawVisibleCallHighlights(GC gC) {
        gC.setAlpha(50);
        gC.setBackground(this.mVisibleCallsHighlightColor);
        gC.fillRectangle(this.mPositionHelper.getBoundsFramingCalls(this.mVisibleCallTopIndex - this.mStartCallIndex, this.mVisibleCallBottomIndex - this.mStartCallIndex));
        gC.setAlpha(255);
    }

    private void drawMouseMarkers(GC gC) {
        if (!this.mMouseInSelf) {
            return;
        }
        if (this.mPositionHelper.getCallAt(this.mMouseY) < 0) {
            return;
        }
        gC.setForeground(this.mMouseMarkerColor);
        gC.drawLine(0, this.mMouseY, this.getClientArea().width, this.mMouseY);
    }

    private void controlResized() {
        this.disposeBackBuffer();
        this.initializeBackBuffer();
        this.redraw();
    }

    public int getMinimumWidth() {
        return this.mPositionHelper.getMinimumWidth();
    }

    public void setCallRangeForCurrentFrame(int n, int n2) {
        this.mStartCallIndex = n;
        this.mEndCallIndex = n2;
        this.mPositionHelper.updateCallDensity(this.mEndCallIndex - this.mStartCallIndex, this.getClientArea().height);
        this.redraw();
    }

    public void setVisibleCallRange(int n, int n2) {
        this.mVisibleCallTopIndex = n;
        this.mVisibleCallBottomIndex = n2;
        this.redraw();
    }

    public void addCallSelectionListener(ICallSelectionListener iCallSelectionListener) {
        this.mListeners.add(iCallSelectionListener);
    }

    private void sendCallSelectedEvent(int n) {
        for (ICallSelectionListener iCallSelectionListener : this.mListeners) {
            iCallSelectionListener.callSelected(n);
        }
    }

    public static interface ICallSelectionListener {
        public void callSelected(int var1);
    }

    private static class PositionHelper {
        private static final int LEFT_MARGIN = 5;
        private static final int TOP_MARGIN = 5;
        private static final int CONTEXT_PADDING = 10;
        private final int mHeaderMargin;
        private final int mContextCount;
        private final int mMaxDurationLength;
        private final long mMaxDuration;
        private final double mScale;
        private int mCallCount;
        private int mNumCallsPerPixel = 1;

        public PositionHelper(int n, int n2, int n3, long l) {
            this.mContextCount = n2;
            this.mMaxDurationLength = n3;
            this.mMaxDuration = l;
            this.mScale = (double)n3 / (double)l;
            this.mHeaderMargin = this.mContextCount > 1 ? n * 3 : 0;
        }

        public int getMinimumWidth() {
            return 5 + (this.mMaxDurationLength + 10) * this.mContextCount;
        }

        public Rectangle getDurationBounds(int n, int n2, long l) {
            if (l <= 0L) {
                l = 1L;
            } else if (l > this.mMaxDuration) {
                l = this.mMaxDuration;
            }
            int n3 = 5 + (this.mMaxDurationLength + 10) * n2;
            int n4 = n / this.mNumCallsPerPixel + 5 + this.mHeaderMargin;
            int n5 = (int)((double)l * this.mScale);
            int n6 = 1;
            return new Rectangle(n3, n4, n5, n6);
        }

        public long getMaxDuration() {
            return this.mMaxDuration;
        }

        public Rectangle getBoundsFramingCalls(int n, int n2) {
            if (n >= 0 && n2 >= n && n2 <= this.mCallCount) {
                int n3 = 5;
                int n4 = n / this.mNumCallsPerPixel + 5 + this.mHeaderMargin;
                int n5 = (this.mMaxDurationLength + 10) * this.mContextCount;
                int n6 = (n2 - n) / this.mNumCallsPerPixel;
                return new Rectangle(n3, n4, n5, n6);
            }
            return new Rectangle(0, 0, 0, 0);
        }

        public Point getHeaderLocation(int n) {
            int n2 = 5 + (this.mMaxDurationLength + 10) * n;
            return new Point(n2, 5);
        }

        public void updateCallDensity(int n, int n2) {
            this.mCallCount = n;
            if (n2 <= 0) {
                n2 = n + 1;
            }
            this.mNumCallsPerPixel = n / n2 + 1;
        }

        public int getCallUnderScanValue() {
            return this.mNumCallsPerPixel;
        }

        public int getCallAt(int n) {
            if (!this.isWithinBounds(n)) {
                return -1;
            }
            Rectangle rectangle = this.getBoundsFramingCalls(0, this.mCallCount);
            return (n - rectangle.y) * this.mNumCallsPerPixel;
        }

        private boolean isWithinBounds(int n) {
            Rectangle rectangle = this.getBoundsFramingCalls(0, this.mCallCount);
            if (n < rectangle.y) {
                return false;
            }
            return n <= rectangle.y + rectangle.height;
        }
    }
}

