/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.GLAbstractAtomicProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;

public class GLIntegerProperty
extends GLAbstractAtomicProperty {
    private final Integer mDefaultValue;
    private Integer mCurrentValue;
    private final DisplayRadix mRadix;

    public GLIntegerProperty(GLStateType gLStateType, Integer n, DisplayRadix displayRadix) {
        super(gLStateType);
        this.mDefaultValue = this.mCurrentValue = n;
        this.mRadix = displayRadix;
    }

    public GLIntegerProperty(GLStateType gLStateType, Integer n) {
        this(gLStateType, n, DisplayRadix.DECIMAL);
    }

    @Override
    public boolean isDefault() {
        return this.mCurrentValue == this.mDefaultValue;
    }

    public void setValue(Integer n) {
        this.mCurrentValue = n;
    }

    @Override
    public String getStringValue() {
        if (this.mRadix == DisplayRadix.HEX) {
            return String.format("0x%08x", (int)this.mCurrentValue);
        }
        return this.mCurrentValue.toString();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException("Attempt to set non-integer value for " + (Object)((Object)this.getType()));
        }
        this.mCurrentValue = (Integer)object;
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }

    public static enum DisplayRadix {
        DECIMAL,
        HEX;

    }
}

