/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IPredicate;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;

public class PropertyChangeTransform
implements IStateTransform {
    private final IGLPropertyAccessor mAccessor;
    private final Object mNewValue;
    private final IPredicate mPredicate;
    private Object mOldValue;

    PropertyChangeTransform(IGLPropertyAccessor iGLPropertyAccessor, Object object) {
        this(iGLPropertyAccessor, object, null);
    }

    public PropertyChangeTransform(IGLPropertyAccessor iGLPropertyAccessor, Object object, IPredicate iPredicate) {
        this.mAccessor = iGLPropertyAccessor;
        this.mNewValue = object;
        this.mPredicate = iPredicate;
        this.mOldValue = null;
    }

    @Override
    public void apply(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = this.mAccessor.getProperty(iGLProperty);
        assert (this.mOldValue == null) : "Transform cannot be applied multiple times";
        if (this.mPredicate != null && !this.mPredicate.apply(iGLProperty2.getValue())) {
            return;
        }
        if (iGLProperty2 == null) {
            throw new RuntimeException("No such property: " + this.mAccessor.getPath());
        }
        this.mOldValue = iGLProperty2.getValue();
        iGLProperty2.setValue(this.mNewValue);
    }

    @Override
    public void revert(IGLProperty iGLProperty) {
        if (this.mOldValue != null) {
            IGLProperty iGLProperty2 = this.mAccessor.getProperty(iGLProperty);
            iGLProperty2.setValue(this.mOldValue);
            this.mOldValue = null;
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty iGLProperty) {
        if (this.mPredicate != null) {
            Object object;
            Object object2 = object = this.mOldValue == null ? this.mNewValue : this.mOldValue;
            if (!this.mPredicate.apply(object)) {
                return null;
            }
        }
        return this.mAccessor.getProperty(iGLProperty);
    }
}

