/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLIntegerProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.GLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;

public class TextureUnitPropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final IGLPropertyAccessor mActiveTextureAccessor;
    private final GLStateType mTargetType;

    public TextureUnitPropertyAccessor(int n, GLStateType gLStateType) {
        this.mContextId = n;
        this.mTargetType = gLStateType;
        this.mActiveTextureAccessor = GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.ACTIVE_TEXTURE_UNIT});
    }

    @Override
    public IGLProperty getProperty(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = this.mActiveTextureAccessor.getProperty(iGLProperty);
        if (!(iGLProperty2 instanceof GLIntegerProperty)) {
            return null;
        }
        Integer n = (Integer)iGLProperty2.getValue();
        IGLPropertyAccessor iGLPropertyAccessor = GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.TEXTURE_STATE, GLStateType.TEXTURE_UNITS, n, this.mTargetType});
        return iGLPropertyAccessor.getProperty(iGLProperty);
    }

    @Override
    public String getPath() {
        return String.format("TEXTURE_STATE/TEXTURE_UNITS/${activeTextureUnit}/%s", new Object[]{this.mTargetType});
    }
}

