/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.views.detail;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.GLUtils;
import com.android.ide.eclipse.gltrace.state.GLCompositeProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.views.detail.IStateDetailProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VboDetailProvider
implements IStateDetailProvider {
    private Composite mComposite;
    private Label mSizeLabel;
    private Label mUsageLabel;
    private Label mTypeLabel;
    private Combo mDisplayFormatCombo;
    private Text mTextControl;
    private byte[] mBufferData;

    @Override
    public boolean isApplicable(IGLProperty iGLProperty) {
        return this.getVboProperty(iGLProperty) != null;
    }

    @Override
    public void createControl(Composite composite) {
        this.mComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.mComposite.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mComposite);
        Label label = new Label(this.mComposite, 0);
        label.setText("Size: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        this.mSizeLabel = new Label(this.mComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mSizeLabel);
        label = new Label(this.mComposite, 0);
        label.setText("Usage: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        this.mUsageLabel = new Label(this.mComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mUsageLabel);
        label = new Label(this.mComposite, 0);
        label.setText("Type: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        this.mTypeLabel = new Label(this.mComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mTypeLabel);
        label = new Label(this.mComposite, 0);
        label.setText("Format Data As: ");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        DisplayFormat[] displayFormatArray = DisplayFormat.values();
        ArrayList<String> arrayList = new ArrayList<String>(displayFormatArray.length);
        DisplayFormat[] displayFormatArray2 = displayFormatArray;
        int n = displayFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayFormat displayFormat = displayFormatArray2[n2];
            arrayList.add(displayFormat.name());
            ++n2;
        }
        this.mDisplayFormatCombo = new Combo(this.mComposite, 12);
        this.mDisplayFormatCombo.setItems(arrayList.toArray(new String[arrayList.size()]));
        this.mDisplayFormatCombo.select(0);
        this.mDisplayFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VboDetailProvider.this.updateContents();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mDisplayFormatCombo);
        this.mTextControl = new Text(this.mComposite, 2890);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.mTextControl);
        this.mTextControl.setEditable(false);
    }

    @Override
    public void disposeControl() {
    }

    @Override
    public Control getControl() {
        return this.mComposite;
    }

    @Override
    public void updateControl(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = this.getVboProperty(iGLProperty);
        if (iGLProperty2 instanceof GLCompositeProperty) {
            GLCompositeProperty gLCompositeProperty = (GLCompositeProperty)iGLProperty2;
            IGLProperty iGLProperty3 = gLCompositeProperty.getProperty(GLStateType.BUFFER_SIZE);
            this.mSizeLabel.setText(String.valueOf(iGLProperty3.getStringValue()) + " bytes");
            IGLProperty iGLProperty4 = gLCompositeProperty.getProperty(GLStateType.BUFFER_USAGE);
            this.mUsageLabel.setText(iGLProperty4.getStringValue());
            IGLProperty iGLProperty5 = gLCompositeProperty.getProperty(GLStateType.BUFFER_TYPE);
            this.mTypeLabel.setText(iGLProperty5.getStringValue());
            IGLProperty iGLProperty6 = gLCompositeProperty.getProperty(GLStateType.BUFFER_DATA);
            this.mBufferData = (byte[])iGLProperty6.getValue();
        } else {
            this.mBufferData = null;
        }
        this.updateContents();
    }

    private void updateContents() {
        if (this.mBufferData != null) {
            this.mTextControl.setText(GLUtils.formatData(this.mBufferData, GLEnum.valueOf(this.mDisplayFormatCombo.getText())));
            this.mTextControl.setEnabled(true);
            this.mDisplayFormatCombo.setEnabled(true);
        } else {
            this.mTextControl.setText("");
            this.mTextControl.setEnabled(false);
            this.mDisplayFormatCombo.setEnabled(false);
        }
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return Collections.emptyList();
    }

    private IGLProperty getVboProperty(IGLProperty iGLProperty) {
        if (iGLProperty.getType() == GLStateType.VBO_COMPOSITE) {
            return iGLProperty;
        }
        if ((iGLProperty = iGLProperty.getParent()) != null && iGLProperty.getType() == GLStateType.VBO_COMPOSITE) {
            return iGLProperty;
        }
        return null;
    }

    private static enum DisplayFormat {
        GL_FLOAT,
        GL_BYTE,
        GL_UNSIGNED_BYTE,
        GL_SHORT,
        GL_UNSIGNED_SHORT,
        GL_FIXED;

    }
}

