/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmuilib.logcat.ILogCatBufferChangeListener;
import com.android.ddmuilib.logcat.LogCatReceiver;
import com.android.ddmuilib.logcat.LogCatReceiverFactory;
import com.android.ide.eclipse.ddms.IDebuggerConnector;
import com.android.ide.eclipse.ddms.LogCatMonitorDialog;
import com.android.ide.eclipse.ddms.views.LogCatView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LogCatMonitor {
    public static final String AUTO_MONITOR_PREFKEY = "ddms.logcat.automonitor";
    public static final String AUTO_MONITOR_LOGLEVEL = "ddms.logcat.auotmonitor.level";
    private static final String AUTO_MONITOR_PROMPT_SHOWN = "ddms.logcat.automonitor.userprompt";
    private IPreferenceStore mPrefStore;
    private Map<String, DeviceData> mMonitoredDevices;
    private IDebuggerConnector[] mConnectors;
    private int mMinMessagePriority;
    final AtomicBoolean mMonitorEnabled = new AtomicBoolean(false);

    public LogCatMonitor(IDebuggerConnector[] iDebuggerConnectorArray, IPreferenceStore iPreferenceStore) {
        this.mConnectors = iDebuggerConnectorArray;
        this.mPrefStore = iPreferenceStore;
        this.mMinMessagePriority = Log.LogLevel.getByString((String)this.mPrefStore.getString(AUTO_MONITOR_LOGLEVEL)).getPriority();
        this.mMonitoredDevices = new HashMap<String, DeviceData>();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceDisconnected(IDevice iDevice) {
                LogCatMonitor.this.unmonitorDevice(iDevice.getSerialNumber());
                LogCatMonitor.this.mMonitoredDevices.remove(iDevice.getSerialNumber());
            }

            public void deviceConnected(IDevice iDevice) {
            }

            public void deviceChanged(IDevice iDevice, int n) {
            }
        });
        this.mPrefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (LogCatMonitor.AUTO_MONITOR_PREFKEY.equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue().equals(false)) {
                    LogCatMonitor.this.unmonitorAllDevices();
                } else if (LogCatMonitor.AUTO_MONITOR_LOGLEVEL.equals(propertyChangeEvent.getProperty())) {
                    LogCatMonitor.this.mMinMessagePriority = Log.LogLevel.getByString((String)((String)propertyChangeEvent.getNewValue())).getPriority();
                }
            }
        });
    }

    private void unmonitorAllDevices() {
        for (String string : this.mMonitoredDevices.keySet()) {
            this.unmonitorDevice(string);
        }
        this.mMonitoredDevices.clear();
    }

    private void unmonitorDevice(String string) {
        DeviceData deviceData = this.mMonitoredDevices.get(string);
        if (deviceData == null) {
            return;
        }
        deviceData.receiver.removeMessageReceivedEventListener(deviceData.bufferChangeListener);
    }

    public void monitorDevice(final IDevice iDevice) {
        if (!this.mPrefStore.getBoolean(AUTO_MONITOR_PREFKEY)) {
            return;
        }
        this.mMonitorEnabled.set(true);
        if (this.mMonitoredDevices.keySet().contains(iDevice.getSerialNumber())) {
            return;
        }
        LogCatReceiver logCatReceiver = LogCatReceiverFactory.INSTANCE.newReceiver(iDevice, this.mPrefStore);
        ILogCatBufferChangeListener iLogCatBufferChangeListener = new ILogCatBufferChangeListener(){

            public void bufferChanged(List<LogCatMessage> list, List<LogCatMessage> list2) {
                LogCatMonitor.this.checkMessages(list, iDevice);
            }
        };
        logCatReceiver.addMessageReceivedEventListener(iLogCatBufferChangeListener);
        this.mMonitoredDevices.put(iDevice.getSerialNumber(), new DeviceData(logCatReceiver, iLogCatBufferChangeListener));
    }

    private void checkMessages(List<LogCatMessage> list, IDevice iDevice) {
        if (!this.mMonitorEnabled.get()) {
            return;
        }
        for (LogCatMessage logCatMessage : list) {
            if (!this.isImportantMessage(logCatMessage)) continue;
            this.focusLogCatView(iDevice, logCatMessage.getAppName());
            this.mMonitorEnabled.set(false);
            break;
        }
    }

    private boolean isImportantMessage(LogCatMessage logCatMessage) {
        if (logCatMessage.getLogLevel().getPriority() < this.mMinMessagePriority) {
            return false;
        }
        String string = logCatMessage.getAppName();
        IDebuggerConnector[] iDebuggerConnectorArray = this.mConnectors;
        int n = this.mConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            IDebuggerConnector iDebuggerConnector = iDebuggerConnectorArray[n2];
            if (iDebuggerConnector.isWorkspaceApp(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void focusLogCatView(final IDevice iDevice, final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage == null) {
                    return;
                }
                if (!this.isLogCatViewVisible(iWorkbenchPage) && !(bl = this.promptUserOnce(iWorkbenchPage.getWorkbenchWindow().getShell()))) {
                    return;
                }
                LogCatView logCatView = this.displayLogCatView(iWorkbenchPage);
                if (logCatView == null) {
                    return;
                }
                logCatView.selectionChanged(iDevice);
                logCatView.selectTransientAppFilter(string);
            }

            private boolean isLogCatViewVisible(IWorkbenchPage iWorkbenchPage) {
                IViewPart iViewPart = iWorkbenchPage.findView("com.android.ide.eclipse.ddms.views.LogCatView");
                return iViewPart != null && iWorkbenchPage.isPartVisible((IWorkbenchPart)iViewPart);
            }

            private LogCatView displayLogCatView(IWorkbenchPage iWorkbenchPage) {
                IViewPart iViewPart = iWorkbenchPage.findView("com.android.ide.eclipse.ddms.views.LogCatView");
                if (iViewPart != null) {
                    iWorkbenchPage.bringToTop((IWorkbenchPart)iViewPart);
                    if (iViewPart instanceof LogCatView) {
                        return (LogCatView)iViewPart;
                    }
                }
                try {
                    return (LogCatView)iWorkbenchPage.showView("com.android.ide.eclipse.ddms.views.LogCatView");
                }
                catch (PartInitException partInitException) {
                    return null;
                }
            }

            private boolean promptUserOnce(Shell shell) {
                boolean bl = LogCatMonitor.this.mPrefStore.getBoolean(LogCatMonitor.AUTO_MONITOR_PROMPT_SHOWN);
                if (bl) {
                    return LogCatMonitor.this.mPrefStore.getBoolean(LogCatMonitor.AUTO_MONITOR_PREFKEY);
                }
                LogCatMonitorDialog logCatMonitorDialog = new LogCatMonitorDialog(shell);
                int n = logCatMonitorDialog.open();
                LogCatMonitor.this.mPrefStore.setValue(LogCatMonitor.AUTO_MONITOR_PROMPT_SHOWN, true);
                LogCatMonitor.this.mPrefStore.setValue(LogCatMonitor.AUTO_MONITOR_PREFKEY, logCatMonitorDialog.shouldMonitor());
                LogCatMonitor.this.mPrefStore.setValue(LogCatMonitor.AUTO_MONITOR_LOGLEVEL, logCatMonitorDialog.getMinimumPriority());
                return n == 0 && logCatMonitorDialog.shouldMonitor();
            }
        });
    }

    private static class DeviceData {
        public final LogCatReceiver receiver;
        public final ILogCatBufferChangeListener bufferChangeListener;

        public DeviceData(LogCatReceiver logCatReceiver, ILogCatBufferChangeListener iLogCatBufferChangeListener) {
            this.receiver = logCatReceiver;
            this.bufferChangeListener = iLogCatBufferChangeListener;
        }
    }
}

