/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.android.ddmuilib.TableHelper;
import com.android.ide.eclipse.ddms.systrace.ISystraceOptions;
import com.android.ide.eclipse.ddms.systrace.ISystraceOptionsDialog;
import com.android.ide.eclipse.ddms.systrace.SystraceTag;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SystraceOptionsDialogV2
extends TitleAreaDialog
implements ISystraceOptionsDialog {
    private static final String TITLE = "Android System Trace";
    private static final String DEFAULT_MESSAGE = "Settings to use while capturing system level trace";
    private static final String DEFAULT_TRACE_FNAME = "trace.html";
    private Text mDestinationText;
    private String mDestinationPath;
    private Text mTraceDurationText;
    private Text mTraceBufferSizeText;
    private Combo mTraceAppCombo;
    private static String sSaveToFolder = System.getProperty("user.home");
    private static String sTraceDuration = "";
    private static String sTraceBufferSize = "";
    private static Set<String> sEnabledTags = new HashSet<String>();
    private static String sLastSelectedApp = null;
    private final List<SystraceTag> mSupportedTags;
    private final List<String> mCurrentApps;
    private final SystraceOptions mOptions = new SystraceOptions();
    private Table mTable;

    public SystraceOptionsDialogV2(Shell shell, List<SystraceTag> list, List<String> list2) {
        super(shell);
        this.mSupportedTags = list;
        this.mCurrentApps = list2;
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText("Destination File: ");
        this.mDestinationText = new Text(composite2, 2048);
        this.mDestinationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mDestinationText.setText(String.valueOf(sSaveToFolder) + File.separator + DEFAULT_TRACE_FNAME);
        final Button button = new Button(composite2, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = SystraceOptionsDialogV2.this.openBrowseDialog(button.getShell());
                if (string != null) {
                    SystraceOptionsDialogV2.this.mDestinationText.setText(string);
                }
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label2.setText("Trace duration (seconds): ");
        this.mTraceDurationText = new Text(composite2, 2048);
        this.mTraceDurationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mTraceDurationText.setText(sTraceDuration);
        Label label3 = new Label(composite2, 0);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label3.setText("Trace Buffer Size (kb): ");
        this.mTraceBufferSizeText = new Text(composite2, 2048);
        this.mTraceBufferSizeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.mTraceBufferSizeText.setText(sTraceBufferSize);
        Label label4 = new Label(composite2, 0);
        label4.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label4.setText("Enable Application Traces from: ");
        this.mTraceAppCombo = new Combo(composite2, 12);
        this.mTraceAppCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        String[] stringArray = new String[this.mCurrentApps.size() + 1];
        stringArray[0] = "None";
        int n = 0;
        while (n < this.mCurrentApps.size()) {
            stringArray[n + 1] = this.mCurrentApps.get(n);
            ++n;
        }
        this.mTraceAppCombo.setItems(stringArray);
        if (sLastSelectedApp != null) {
            this.mTraceAppCombo.setText(sLastSelectedApp);
        } else {
            this.mTraceAppCombo.select(0);
        }
        Label label5 = new Label(composite2, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        label5.setLayoutData((Object)gridData);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SystraceOptionsDialogV2.this.validateFields();
            }
        };
        this.mDestinationText.addModifyListener(modifyListener);
        this.mTraceBufferSizeText.addModifyListener(modifyListener);
        this.mTraceDurationText.addModifyListener(modifyListener);
        label = new Label(composite2, 0);
        label.setText("Select tags to enable: ");
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mTable = new Table(composite2, 2080);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.mTable.setLayoutData((Object)gridData);
        this.mTable.setHeaderVisible(false);
        this.mTable.setLinesVisible(false);
        for (SystraceTag systraceTag : this.mSupportedTags) {
            TableItem tableItem = new TableItem(this.mTable, 0);
            tableItem.setText(systraceTag.info);
            tableItem.setChecked(sEnabledTags.contains(systraceTag.tag));
        }
        TableHelper.createTableColumn((Table)this.mTable, (String)"TagHeaderNotDisplayed", (int)16384, (String)"SampleTagForColumnLengthCalculation", null, null);
        return composite2;
    }

    private void validateFields() {
        String string = this.validatePath(this.mDestinationText.getText());
        if (string != null) {
            this.setErrorMessage(string);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.validateInteger(this.mTraceDurationText.getText())) {
            this.setErrorMessage("Trace Duration should be a valid integer (seconds)");
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.validateInteger(this.mTraceBufferSizeText.getText())) {
            this.setErrorMessage("Trace Buffer Size should be a valid integer (kilobytes)");
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
        this.setErrorMessage(null);
    }

    private boolean validateInteger(String string) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String validatePath(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        File file = new File(string);
        if (file.isDirectory()) {
            return String.format("The path '%s' points to a folder", string);
        }
        if (!file.exists() && !file.getParentFile().isDirectory()) {
            return String.format("That path '%s' is not a valid folder.", file.getParent());
        }
        return null;
    }

    private String openBrowseDialog(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("Save To");
        fileDialog.setFileName(DEFAULT_TRACE_FNAME);
        fileDialog.setFilterPath(sSaveToFolder);
        fileDialog.setFilterExtensions(new String[]{"*.html"});
        String string = fileDialog.open();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        sSaveToFolder = fileDialog.getFilterPath();
        return string;
    }

    protected void okPressed() {
        this.mDestinationPath = this.mDestinationText.getText().trim();
        sTraceDuration = this.mTraceDurationText.getText();
        if (!sTraceDuration.isEmpty()) {
            this.mOptions.mTraceDuration = Integer.parseInt(SystraceOptionsDialogV2.sTraceDuration);
        }
        if (!(sTraceBufferSize = this.mTraceBufferSizeText.getText()).isEmpty()) {
            this.mOptions.mTraceBufferSize = Integer.parseInt(SystraceOptionsDialogV2.sTraceBufferSize);
        }
        if (this.mTraceAppCombo.getSelectionIndex() != 0) {
            sLastSelectedApp = this.mTraceAppCombo.getText();
            this.mOptions.mTraceApp = SystraceOptionsDialogV2.sLastSelectedApp;
        }
        sEnabledTags.clear();
        int n = 0;
        while (n < this.mTable.getItemCount()) {
            TableItem tableItem = this.mTable.getItem(n);
            if (tableItem.getChecked()) {
                sEnabledTags.add(this.mSupportedTags.get((int)n).tag);
            }
            ++n;
        }
        super.okPressed();
    }

    @Override
    public ISystraceOptions getSystraceOptions() {
        return this.mOptions;
    }

    @Override
    public String getTraceFilePath() {
        return this.mDestinationPath;
    }

    private class SystraceOptions
    implements ISystraceOptions {
        private int mTraceBufferSize;
        private int mTraceDuration;
        private String mTraceApp;

        private SystraceOptions() {
        }

        @Override
        public String getTags() {
            return null;
        }

        @Override
        public String getOptions() {
            StringBuilder stringBuilder = new StringBuilder(5 * SystraceOptionsDialogV2.this.mSupportedTags.size());
            if (this.mTraceApp != null) {
                stringBuilder.append("-a ");
                stringBuilder.append(this.mTraceApp);
                stringBuilder.append(' ');
            }
            if (this.mTraceDuration > 0) {
                stringBuilder.append("-t");
                stringBuilder.append(this.mTraceDuration);
                stringBuilder.append(' ');
            }
            if (this.mTraceBufferSize > 0) {
                stringBuilder.append("-b ");
                stringBuilder.append(this.mTraceBufferSize);
                stringBuilder.append(' ');
            }
            for (String string : sEnabledTags) {
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            return stringBuilder.toString().trim();
        }
    }
}

