/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class SystraceOutputParser {
    private static final String TRACE_START = "TRACE:\n";
    private final boolean mUncompress;
    private final String mJs;
    private final String mCss;
    private final String mHtmlPrefix;
    private final String mHtmlSuffix;
    private byte[] mAtraceOutput;
    private int mAtraceLength;
    private int mSystraceIndex = -1;

    public SystraceOutputParser(boolean bl, String string, String string2, String string3, String string4) {
        this.mUncompress = bl;
        this.mJs = string;
        this.mCss = string2;
        this.mHtmlPrefix = string3;
        this.mHtmlSuffix = string4;
    }

    public void parse(byte[] byArray) {
        this.mAtraceOutput = byArray;
        this.mAtraceLength = byArray.length;
        this.removeCrLf();
        String string = new String(this.mAtraceOutput, 0, Math.min(100, this.mAtraceLength));
        this.mSystraceIndex = this.locateSystraceData(string);
        if (this.mSystraceIndex < 0) {
            throw new RuntimeException("Unable to find trace start marker 'TRACE:':\n" + string);
        }
    }

    private void removeCrLf() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.mAtraceLength - 1) {
            int n3;
            if (this.mAtraceOutput[n2] == 13 && this.mAtraceOutput[n2 + 1] == 10) {
                n3 = 10;
                ++n2;
            } else {
                n3 = this.mAtraceOutput[n2];
            }
            this.mAtraceOutput[n] = n3;
            ++n2;
            ++n;
        }
        this.mAtraceLength = n;
    }

    private int locateSystraceData(String string) {
        int n = string.indexOf(TRACE_START);
        if (n < 0) {
            return -1;
        }
        return n + TRACE_START.length();
    }

    public String getSystraceHtml() {
        Object object;
        Object object2;
        if (this.mSystraceIndex < 0) {
            return "";
        }
        String string = "";
        if (this.mUncompress) {
            object2 = new Inflater();
            ((Inflater)object2).setInput(this.mAtraceOutput, this.mSystraceIndex, this.mAtraceLength - this.mSystraceIndex);
            object = new byte[4096];
            StringBuilder stringBuilder = new StringBuilder(1000);
            try {
                int n;
                while ((n = ((Inflater)object2).inflate((byte[])object)) > 0) {
                    stringBuilder.append(new String((byte[])object, 0, n));
                }
            }
            catch (DataFormatException dataFormatException) {
                throw new RuntimeException(dataFormatException);
            }
            ((Inflater)object2).end();
            string = stringBuilder.toString();
        } else {
            string = new String(this.mAtraceOutput, this.mSystraceIndex, this.mAtraceLength - this.mSystraceIndex);
        }
        object2 = string.replaceAll("\n", "\\\\n\\\\\n");
        object = String.format(this.mHtmlPrefix, this.mCss, this.mJs, "");
        String string2 = this.mHtmlSuffix;
        return String.valueOf(object) + (String)object2 + string2;
    }

    public static String getJs(File file) {
        try {
            return String.format("<script language=\"javascript\">%s</script>", Files.toString((File)new File(file, "script.js"), (Charset)Charsets.UTF_8));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getCss(File file) {
        try {
            return String.format("<style type=\"text/css\">%s</style>", Files.toString((File)new File(file, "style.css"), (Charset)Charsets.UTF_8));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getHtmlPrefix(File file) {
        return SystraceOutputParser.getHtmlTemplate(file, "prefix.html");
    }

    public static String getHtmlSuffix(File file) {
        return SystraceOutputParser.getHtmlTemplate(file, "suffix.html");
    }

    private static String getHtmlTemplate(File file, String string) {
        try {
            return Files.toString((File)new File(file, string), (Charset)Charsets.UTF_8);
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

