/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmuilib.DevicePanel;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.ScreenShotDialog;
import com.android.ddmuilib.SyncProgressHelper;
import com.android.ddmuilib.handler.BaseFileHandler;
import com.android.ddmuilib.handler.MethodProfilingHandler;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import com.android.ide.eclipse.ddms.IClientAction;
import com.android.ide.eclipse.ddms.IDebuggerConnector;
import com.android.ide.eclipse.ddms.editors.UiAutomatorViewer;
import com.android.ide.eclipse.ddms.i18n.Messages;
import com.android.ide.eclipse.ddms.systrace.ISystraceOptions;
import com.android.ide.eclipse.ddms.systrace.ISystraceOptionsDialog;
import com.android.ide.eclipse.ddms.systrace.SystraceOptionsDialogV1;
import com.android.ide.eclipse.ddms.systrace.SystraceOptionsDialogV2;
import com.android.ide.eclipse.ddms.systrace.SystraceOutputParser;
import com.android.ide.eclipse.ddms.systrace.SystraceTask;
import com.android.ide.eclipse.ddms.systrace.SystraceVersionDetector;
import com.android.uiautomator.UiAutomatorHelper;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class DeviceView
extends ViewPart
implements DevicePanel.IUiSelectionListener,
AndroidDebugBridge.IClientChangeListener {
    private static final boolean USE_SELECTED_DEBUG_PORT = true;
    public static final String ID = "com.android.ide.eclipse.ddms.views.DeviceView";
    private static DeviceView sThis;
    private Shell mParentShell;
    private DevicePanel mDeviceList;
    private Action mResetAdbAction;
    private Action mCaptureAction;
    private Action mViewUiAutomatorHierarchyAction;
    private Action mSystraceAction;
    private Action mUpdateThreadAction;
    private Action mUpdateHeapAction;
    private Action mGcAction;
    private Action mKillAppAction;
    private Action mDebugAction;
    private Action mHprofAction;
    private Action mTracingAction;
    private ImageDescriptor mTracingStartImage;
    private ImageDescriptor mTracingStopImage;

    public DeviceView() {
        sThis = this;
    }

    public static DeviceView getInstance() {
        return sThis;
    }

    public void createPartControl(Composite composite) {
        this.mParentShell = composite.getShell();
        ImageLoader imageLoader = ImageLoader.getDdmUiLibLoader();
        this.mDeviceList = new DevicePanel(true);
        this.mDeviceList.createPanel(composite);
        this.mDeviceList.addSelectionListener((DevicePanel.IUiSelectionListener)this);
        DdmsPlugin ddmsPlugin = DdmsPlugin.getDefault();
        this.mDeviceList.addSelectionListener((DevicePanel.IUiSelectionListener)ddmsPlugin);
        ddmsPlugin.setListeningState(true);
        this.mCaptureAction = new Action(Messages.DeviceView_Screen_Capture){

            public void run() {
                ScreenShotDialog screenShotDialog = new ScreenShotDialog(DdmsPlugin.getDisplay().getActiveShell());
                screenShotDialog.open(DeviceView.this.mDeviceList.getSelectedDevice());
            }
        };
        this.mCaptureAction.setToolTipText(Messages.DeviceView_Screen_Capture_Tooltip);
        this.mCaptureAction.setImageDescriptor(imageLoader.loadDescriptor("capture.png"));
        this.mViewUiAutomatorHierarchyAction = new Action("Dump View Hierarchy for UI Automator"){

            public void run() {
                DeviceView.this.takeUiAutomatorSnapshot(DeviceView.this.mDeviceList.getSelectedDevice(), DdmsPlugin.getDisplay().getActiveShell());
            }
        };
        this.mViewUiAutomatorHierarchyAction.setToolTipText("Dump View Hierarchy for UI Automator");
        this.mViewUiAutomatorHierarchyAction.setImageDescriptor(DdmsPlugin.getImageDescriptor("icons/uiautomator.png"));
        this.mSystraceAction = new Action("Capture System Wide Trace"){

            public void run() {
                DeviceView.this.launchSystrace(DeviceView.this.mDeviceList.getSelectedDevice(), DdmsPlugin.getDisplay().getActiveShell());
            }
        };
        this.mSystraceAction.setToolTipText("Capture system wide trace using Android systrace");
        this.mSystraceAction.setImageDescriptor(DdmsPlugin.getImageDescriptor("icons/systrace.png"));
        this.mSystraceAction.setEnabled(true);
        this.mResetAdbAction = new Action(Messages.DeviceView_Reset_ADB){

            public void run() {
                AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
                if (androidDebugBridge != null && !androidDebugBridge.restart()) {
                    final Display display = DdmsPlugin.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = display.getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)Messages.DeviceView_ADB_Error, (String)Messages.DeviceView_ADB_Failed_Restart);
                        }
                    });
                }
            }
        };
        this.mResetAdbAction.setToolTipText(Messages.DeviceView_Reset_ADB_Host_Deamon);
        this.mResetAdbAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_WARN_TSK"));
        this.mKillAppAction = new Action(){

            public void run() {
                DeviceView.this.mDeviceList.killSelectedClient();
            }
        };
        this.mKillAppAction.setText(Messages.DeviceView_Stop_Process);
        this.mKillAppAction.setToolTipText(Messages.DeviceView_Stop_Process_Tooltip);
        this.mKillAppAction.setImageDescriptor(imageLoader.loadDescriptor("halt.png"));
        this.mGcAction = new Action(){

            public void run() {
                DeviceView.this.mDeviceList.forceGcOnSelectedClient();
            }
        };
        this.mGcAction.setText(Messages.DeviceView_Cause_GC);
        this.mGcAction.setToolTipText(Messages.DeviceView_Cause_GC_Tooltip);
        this.mGcAction.setImageDescriptor(imageLoader.loadDescriptor("gc.png"));
        this.mHprofAction = new Action(){

            public void run() {
                DeviceView.this.mDeviceList.dumpHprof();
                DeviceView.this.doSelectionChanged(DeviceView.this.mDeviceList.getSelectedClient());
            }
        };
        this.mHprofAction.setText(Messages.DeviceView_Dump_HPROF_File);
        this.mHprofAction.setToolTipText(Messages.DeviceView_Dump_HPROF_File_Tooltip);
        this.mHprofAction.setImageDescriptor(imageLoader.loadDescriptor("hprof.png"));
        this.mUpdateHeapAction = new Action(Messages.DeviceView_Update_Heap, 2){

            public void run() {
                boolean bl = DeviceView.this.mUpdateHeapAction.isChecked();
                DeviceView.this.mDeviceList.setEnabledHeapOnSelectedClient(bl);
            }
        };
        this.mUpdateHeapAction.setToolTipText(Messages.DeviceView_Update_Heap_Tooltip);
        this.mUpdateHeapAction.setImageDescriptor(imageLoader.loadDescriptor("heap.png"));
        this.mUpdateThreadAction = new Action(Messages.DeviceView_Threads, 2){

            public void run() {
                boolean bl = DeviceView.this.mUpdateThreadAction.isChecked();
                DeviceView.this.mDeviceList.setEnabledThreadOnSelectedClient(bl);
            }
        };
        this.mUpdateThreadAction.setToolTipText(Messages.DeviceView_Threads_Tooltip);
        this.mUpdateThreadAction.setImageDescriptor(imageLoader.loadDescriptor("thread.png"));
        this.mTracingAction = new Action(){

            public void run() {
                DeviceView.this.mDeviceList.toggleMethodProfiling();
            }
        };
        this.mTracingAction.setText(Messages.DeviceView_Start_Method_Profiling);
        this.mTracingAction.setToolTipText(Messages.DeviceView_Start_Method_Profiling_Tooltip);
        this.mTracingStartImage = imageLoader.loadDescriptor("tracing_start.png");
        this.mTracingStopImage = imageLoader.loadDescriptor("tracing_stop.png");
        this.mTracingAction.setImageDescriptor(this.mTracingStartImage);
        this.mDebugAction = new Action(Messages.DeviceView_Debug_Process){

            public void run() {
                Client client;
                if (DdmsPlugin.getDefault().hasDebuggerConnectors() && (client = DeviceView.this.mDeviceList.getSelectedClient()) != null) {
                    ClientData clientData = client.getClientData();
                    switch (clientData.getDebuggerConnectionStatus()) {
                        case ERROR: {
                            Display display = DdmsPlugin.getDisplay();
                            Shell shell = display.getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)Messages.DeviceView_Debug_Process_Title, (String)Messages.DeviceView_Process_Debug_Already_In_Use);
                            return;
                        }
                        case ATTACHED: {
                            Display display = DdmsPlugin.getDisplay();
                            Shell shell = display.getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)Messages.DeviceView_Debug_Process_Title, (String)Messages.DeviceView_Process_Already_Being_Debugged);
                            return;
                        }
                    }
                    String string = clientData.getClientDescription();
                    if (string != null) {
                        Object object;
                        IDebuggerConnector[] iDebuggerConnectorArray = DdmsPlugin.getDefault().getDebuggerConnectors();
                        if (iDebuggerConnectorArray != null) {
                            IDebuggerConnector[] iDebuggerConnectorArray2 = iDebuggerConnectorArray;
                            int n = iDebuggerConnectorArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                object = iDebuggerConnectorArray2[n2];
                                try {
                                    if (object.connectDebugger(string, client.getDebuggerListenPort(), DdmPreferences.getSelectedDebugPort())) {
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {}
                                ++n2;
                            }
                        }
                        object = DdmsPlugin.getDisplay();
                        Shell shell = object.getActiveShell();
                        MessageDialog.openError((Shell)shell, (String)Messages.DeviceView_Debug_Process_Title, (String)String.format(Messages.DeviceView_Debug_Session_Failed, string));
                    }
                }
            }
        };
        this.mDebugAction.setToolTipText(Messages.DeviceView_Debug_Process_Tooltip);
        this.mDebugAction.setImageDescriptor(imageLoader.loadDescriptor("debug-attach.png"));
        this.mDebugAction.setEnabled(DdmsPlugin.getDefault().hasDebuggerConnectors());
        this.placeActions();
        this.selectionChanged(null, null);
        ClientData.setHprofDumpHandler((ClientData.IHprofDumpHandler)new HProfHandler(this.mParentShell));
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new MethodProfilingHandler(this.mParentShell){

            protected void open(String string) {
                if (!DdmsPlugin.getDefault().launchTraceview(string)) {
                    super.open(string);
                }
            }
        });
    }

    private void takeUiAutomatorSnapshot(final IDevice iDevice, Shell shell) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    UiAutomatorHelper.UiAutomatorResult uiAutomatorResult = null;
                    try {
                        try {
                            uiAutomatorResult = UiAutomatorHelper.takeSnapshot((IDevice)iDevice, (IProgressMonitor)iProgressMonitor);
                        }
                        catch (UiAutomatorHelper.UiAutomatorException uiAutomatorException) {
                            throw new InvocationTargetException(uiAutomatorException);
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                    UiAutomatorViewer.openEditor(uiAutomatorResult);
                }
            });
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)exception).getTargetException();
            }
            Status status = new Status(4, "com.android.ide.eclipse.ddms", "Error obtaining UI hierarchy", throwable);
            ErrorDialog.openError((Shell)shell, (String)"UI Automator", (String)"Unexpected error while obtaining UI hierarchy", (IStatus)status);
        }
    }

    private void launchSystrace(IDevice iDevice, Shell shell) {
        String string;
        Object object;
        Object object2;
        TitleAreaDialog titleAreaDialog;
        File file = new File(DdmsPlugin.getPlatformToolsFolder(), "systrace");
        if (!file.isDirectory()) {
            MessageDialog.openError((Shell)shell, (String)"Systrace", (String)"Updated version of platform-tools (18.0.1 or greater) is required.\nPlease update your platform-tools using SDK Manager.");
            return;
        }
        SystraceVersionDetector systraceVersionDetector = new SystraceVersionDetector(iDevice);
        try {
            new ProgressMonitorDialog(shell).run(true, false, (IRunnableWithProgress)systraceVersionDetector);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)shell, (String)"Systrace", (String)("Unexpected error while detecting atrace version: " + invocationTargetException));
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (systraceVersionDetector.getVersion() == 1) {
            titleAreaDialog = new SystraceOptionsDialogV1(shell);
        } else {
            object2 = iDevice.getClients();
            object = new ArrayList(((Client[])object2).length);
            int n = 0;
            while (n < ((Object)object2).length) {
                string = object2[n].getClientData().getClientDescription();
                if (string != null && !string.isEmpty()) {
                    object.add(string);
                }
                ++n;
            }
            titleAreaDialog = new SystraceOptionsDialogV2(shell, systraceVersionDetector.getTags(), (List<String>)object);
        }
        if (titleAreaDialog.open() != 0) {
            return;
        }
        object2 = titleAreaDialog.getSystraceOptions();
        object = object2.getTags();
        if (object != null) {
            String string2;
            CountDownLatch countDownLatch = new CountDownLatch(1);
            string = new CollectingOutputReceiver(countDownLatch);
            try {
                string2 = "setprop debug.atrace.tags.enableflags " + (String)object;
                iDevice.executeShellCommand(string2, (IShellOutputReceiver)string);
                countDownLatch.await(5L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)shell, (String)"Systrace", (String)("Unexpected error while setting trace tags: " + exception));
                return;
            }
            string2 = string.getOutput();
            if (string2.contains("Error type")) {
                throw new RuntimeException(string.getOutput());
            }
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress((ISystraceOptions)object2, iDevice, file, (ISystraceOptionsDialog)titleAreaDialog){
                private final /* synthetic */ ISystraceOptions val$options;
                private final /* synthetic */ IDevice val$device;
                private final /* synthetic */ File val$systraceAssets;
                private final /* synthetic */ ISystraceOptionsDialog val$dlg;
                {
                    this.val$options = iSystraceOptions;
                    this.val$device = iDevice;
                    this.val$systraceAssets = file;
                    this.val$dlg = iSystraceOptionsDialog;
                }

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    SystraceTask systraceTask;
                    boolean bl;
                    block4: {
                        bl = true;
                        iProgressMonitor.setTaskName("Collecting Trace Information");
                        String string = String.valueOf(this.val$options.getOptions()) + (bl ? " -z" : "");
                        systraceTask = new SystraceTask(this.val$device, string);
                        Thread thread = new Thread((Runnable)systraceTask, "Systrace Output Receiver");
                        thread.start();
                        do {
                            thread.join(1000L);
                            if (!thread.isAlive()) break block4;
                        } while (!iProgressMonitor.isCanceled());
                        systraceTask.cancel();
                        return;
                    }
                    if (systraceTask.getError() != null) {
                        throw new RuntimeException(systraceTask.getError());
                    }
                    iProgressMonitor.setTaskName("Saving trace information");
                    SystraceOutputParser systraceOutputParser = new SystraceOutputParser(bl, SystraceOutputParser.getJs(this.val$systraceAssets), SystraceOutputParser.getCss(this.val$systraceAssets), SystraceOutputParser.getHtmlPrefix(this.val$systraceAssets), SystraceOutputParser.getHtmlSuffix(this.val$systraceAssets));
                    systraceOutputParser.parse(systraceTask.getAtraceOutput());
                    String string = systraceOutputParser.getSystraceHtml();
                    try {
                        Files.write((byte[])string.getBytes(), (File)new File(this.val$dlg.getTraceFilePath()));
                    }
                    catch (IOException iOException) {
                        throw new InvocationTargetException(iOException);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorDialog.openError((Shell)shell, (String)"Systrace", (String)"Unable to collect system trace.", (IStatus)new Status(4, "com.android.ide.eclipse.ddms", "Unexpected error while collecting system trace.", invocationTargetException.getCause()));
        }
        catch (InterruptedException interruptedException) {}
    }

    public void setFocus() {
        this.mDeviceList.setFocus();
    }

    public void selectionChanged(IDevice iDevice, Client client) {
        this.doSelectionChanged(client);
        this.doSelectionChanged(iDevice);
    }

    private void doSelectionChanged(Client client) {
        if (client != null) {
            client.setAsSelectedClient();
            this.mDebugAction.setEnabled(DdmsPlugin.getDefault().hasDebuggerConnectors());
            this.mKillAppAction.setEnabled(true);
            this.mGcAction.setEnabled(true);
            this.mUpdateHeapAction.setEnabled(true);
            this.mUpdateHeapAction.setChecked(client.isHeapUpdateEnabled());
            this.mUpdateThreadAction.setEnabled(true);
            this.mUpdateThreadAction.setChecked(client.isThreadUpdateEnabled());
            ClientData object2 = client.getClientData();
            if (object2.hasFeature("hprof-heap-dump")) {
                this.mHprofAction.setEnabled(!object2.hasPendingHprofDump());
                this.mHprofAction.setToolTipText(Messages.DeviceView_Dump_HPROF_File);
            } else {
                this.mHprofAction.setEnabled(false);
                this.mHprofAction.setToolTipText(Messages.DeviceView_Dump_HPROF_File_Not_Supported_By_VM);
            }
            if (object2.hasFeature("method-trace-profiling")) {
                this.mTracingAction.setEnabled(true);
                if (object2.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON || object2.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.SAMPLER_ON) {
                    this.mTracingAction.setToolTipText(Messages.DeviceView_Stop_Method_Profiling_Tooltip);
                    this.mTracingAction.setText(Messages.DeviceView_Stop_Method_Profiling);
                    this.mTracingAction.setImageDescriptor(this.mTracingStopImage);
                } else {
                    this.mTracingAction.setToolTipText(Messages.DeviceView_Start_Method_Profiling_Tooltip);
                    this.mTracingAction.setImageDescriptor(this.mTracingStartImage);
                    this.mTracingAction.setText(Messages.DeviceView_Start_Method_Profiling);
                }
            } else {
                this.mTracingAction.setEnabled(false);
                this.mTracingAction.setImageDescriptor(this.mTracingStartImage);
                this.mTracingAction.setToolTipText(Messages.DeviceView_Start_Method_Profiling_Not_Suported_By_Vm);
                this.mTracingAction.setText(Messages.DeviceView_Start_Method_Profiling);
            }
        } else {
            AndroidDebugBridge androidDebugBridge = AndroidDebugBridge.getBridge();
            if (androidDebugBridge != null) {
                androidDebugBridge.setSelectedClient(null);
            }
            this.mDebugAction.setEnabled(false);
            this.mKillAppAction.setEnabled(false);
            this.mGcAction.setEnabled(false);
            this.mUpdateHeapAction.setChecked(false);
            this.mUpdateHeapAction.setEnabled(false);
            this.mUpdateThreadAction.setEnabled(false);
            this.mUpdateThreadAction.setChecked(false);
            this.mHprofAction.setEnabled(false);
            this.mHprofAction.setEnabled(false);
            this.mHprofAction.setToolTipText(Messages.DeviceView_Dump_HPROF_File);
            this.mTracingAction.setEnabled(false);
            this.mTracingAction.setImageDescriptor(this.mTracingStartImage);
            this.mTracingAction.setToolTipText(Messages.DeviceView_Start_Method_Profiling_Tooltip);
            this.mTracingAction.setText(Messages.DeviceView_Start_Method_Profiling);
        }
        for (IClientAction iClientAction : DdmsPlugin.getDefault().getClientSpecificActions()) {
            iClientAction.selectedClientChanged(client);
        }
    }

    private void doSelectionChanged(IDevice iDevice) {
        boolean bl = iDevice != null;
        this.mCaptureAction.setEnabled(bl);
        this.mViewUiAutomatorHierarchyAction.setEnabled(bl);
        this.mSystraceAction.setEnabled(bl);
    }

    private final void placeActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.removeAll();
        iMenuManager.add((IAction)this.mDebugAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mUpdateHeapAction);
        iMenuManager.add((IAction)this.mHprofAction);
        iMenuManager.add((IAction)this.mGcAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mUpdateThreadAction);
        iMenuManager.add((IAction)this.mTracingAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mKillAppAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mCaptureAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mViewUiAutomatorHierarchyAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mSystraceAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.mResetAdbAction);
        for (IClientAction iClientAction : DdmsPlugin.getDefault().getClientSpecificActions()) {
            iMenuManager.add((IAction)iClientAction.getAction());
        }
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.removeAll();
        iToolBarManager.add((IAction)this.mDebugAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mUpdateHeapAction);
        iToolBarManager.add((IAction)this.mHprofAction);
        iToolBarManager.add((IAction)this.mGcAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mUpdateThreadAction);
        iToolBarManager.add((IAction)this.mTracingAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mKillAppAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mCaptureAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mViewUiAutomatorHierarchyAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.mSystraceAction);
        for (IClientAction iClientAction : DdmsPlugin.getDefault().getClientSpecificActions()) {
            iToolBarManager.add((IAction)iClientAction.getAction());
        }
    }

    public void clientChanged(final Client client, int n) {
        if ((n & 0x800) == 2048 && this.mDeviceList.getSelectedClient() == client) {
            this.mParentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DeviceView.this.doSelectionChanged(client);
                }
            });
        }
    }

    public class HProfHandler
    extends BaseFileHandler
    implements ClientData.IHprofDumpHandler {
        public static final String ACTION_SAVE = "hprof.save";
        public static final String ACTION_OPEN = "hprof.open";
        public static final String DOT_HPROF = ".hprof";

        HProfHandler(Shell shell) {
            super(shell);
        }

        protected String getDialogTitle() {
            return Messages.DeviceView_HPROF_Error;
        }

        public void onEndFailure(final Client client, final String string) {
            this.mParentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        HProfHandler.this.displayErrorFromUiThread(Messages.DeviceView_Unable_Create_HPROF_For_Application, new Object[]{client.getClientData().getClientDescription(), string != null ? String.valueOf(string) + "\n\n" : ""});
                    }
                    finally {
                        DeviceView.this.doSelectionChanged(DeviceView.this.mDeviceList.getSelectedClient());
                    }
                }
            });
        }

        public void onSuccess(final String string, final Client client) {
            this.mParentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IDevice iDevice = client.getDevice();
                    try {
                        try {
                            final SyncService syncService = client.getDevice().getSyncService();
                            if (syncService != null) {
                                IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
                                String string3 = iPreferenceStore.getString("com.android.ide.eclipse.ddms.hprofAction");
                                if (HProfHandler.ACTION_OPEN.equals(string3)) {
                                    File file = File.createTempFile("android", HProfHandler.DOT_HPROF);
                                    final String string2 = file.getAbsolutePath();
                                    SyncProgressHelper.run((SyncProgressHelper.SyncRunnable)new SyncProgressHelper.SyncRunnable(){

                                        public void run(SyncService.ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
                                            syncService.pullFile(string, string2, iSyncProgressMonitor);
                                        }

                                        public void close() {
                                            syncService.close();
                                        }
                                    }, (String)String.format(Messages.DeviceView_Pulling_From_Device, string), (Shell)HProfHandler.this.mParentShell);
                                    HProfHandler.this.open(string2);
                                } else {
                                    HProfHandler.this.promptAndPull(syncService, String.valueOf(client.getClientData().getClientDescription()) + HProfHandler.DOT_HPROF, string, Messages.DeviceView_Save_HPROF_File);
                                }
                            } else {
                                HProfHandler.this.displayErrorFromUiThread(Messages.DeviceView_Unable_Download_HPROF_From_Device_One_Param_First_Message, new Object[]{iDevice.getSerialNumber()});
                            }
                        }
                        catch (SyncException syncException) {
                            if (!syncException.wasCanceled()) {
                                HProfHandler.this.displayErrorFromUiThread(Messages.DeviceView_Unable_Download_HPROF_From_Device_Two_Param, new Object[]{iDevice.getSerialNumber(), syncException.getMessage()});
                            }
                            DeviceView.this.doSelectionChanged(DeviceView.this.mDeviceList.getSelectedClient());
                        }
                        catch (Exception exception) {
                            HProfHandler.this.displayErrorFromUiThread(Messages.DeviceView_Unable_Download_HPROF_From_Device_One_Param_Second_Message, new Object[]{iDevice.getSerialNumber()});
                            DeviceView.this.doSelectionChanged(DeviceView.this.mDeviceList.getSelectedClient());
                        }
                    }
                    finally {
                        DeviceView.this.doSelectionChanged(DeviceView.this.mDeviceList.getSelectedClient());
                    }
                }
            });
        }

        public void onSuccess(final byte[] byArray, final Client client) {
            this.mParentShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
                    String string = iPreferenceStore.getString("com.android.ide.eclipse.ddms.hprofAction");
                    if (HProfHandler.ACTION_OPEN.equals(string)) {
                        try {
                            File file = HProfHandler.this.saveTempFile(byArray, null);
                            HProfHandler.this.open(file.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            String string2 = exception.getMessage();
                            HProfHandler.this.displayErrorFromUiThread(Messages.DeviceView_Failed_To_Save_HPROF_Data, new Object[]{string2 != null ? ":\n" + string2 : "."});
                        }
                    } else {
                        HProfHandler.this.promptAndSave(String.valueOf(client.getClientData().getClientDescription()) + HProfHandler.DOT_HPROF, byArray, Messages.DeviceView_Save_HPROF_File);
                    }
                }
            });
        }

        private void open(String string) throws IOException, InterruptedException, PartInitException {
            File file = File.createTempFile("android", DOT_HPROF);
            String string2 = file.getAbsolutePath();
            String[] stringArray = new String[]{DdmsPlugin.getHprofConverter(), string, string2};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(string2));
            if (!iFileStore.fetchInfo().isDirectory() && iFileStore.fetchInfo().exists()) {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage == null) {
                    return;
                }
                if (!iWorkbenchPage.isEditorAreaVisible()) {
                    IAdaptable iAdaptable = iWorkbenchPage.getInput();
                    try {
                        iWorkbench.showPerspective("org.eclipse.debug.ui.DebugPerspective", iWorkbenchWindow, iAdaptable);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
                IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
            }
        }
    }
}

