/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.grammar;

import java.util.List;
import lombok.ast.DanglingNodes;
import lombok.ast.Identifier;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;
import lombok.ast.TypeReferencePart;
import lombok.ast.TypeVariable;
import lombok.ast.WildcardKind;
import lombok.ast.grammar.Source;
import lombok.ast.grammar.SourceActions;
import lombok.ast.grammar.TemporaryNode;

public class TypesActions
extends SourceActions {
    public TypesActions(Source source) {
        super(source);
    }

    public Node createPrimitiveType(String text) {
        Identifier identifier = this.posify(new Identifier().astValue(text));
        TypeReferencePart typeReferencePart = this.posify(new TypeReferencePart().astIdentifier(identifier));
        return this.posify(new TypeReference().rawParts().addToStart(typeReferencePart));
    }

    public Node createTypeReferencePart(lombok.ast.libs.org.parboiled.Node<Node> identifier, Node typeArguments) {
        TypeReferencePart result = new TypeReferencePart().astIdentifier(this.createIdentifierIfNeeded(identifier.getValue(), this.currentPos()));
        if (typeArguments instanceof TemporaryNode.TypeArguments) {
            for (Node arg : ((TemporaryNode.TypeArguments)typeArguments).arguments) {
                result.rawTypeArguments().addToEnd(arg);
            }
        }
        this.posify(result);
        return result.setPosition(new Position(identifier.getStartIndex(), result.getPosition().getEnd()));
    }

    public Node createWildcardedType(lombok.ast.libs.org.parboiled.Node<Node> qmark, lombok.ast.libs.org.parboiled.Node<Node> boundType, String extendsOrSuper, Node type) {
        TypeReference ref;
        if (extendsOrSuper != null) {
            extendsOrSuper = extendsOrSuper.trim();
        }
        WildcardKind wildcard = WildcardKind.UNBOUND;
        if ("extends".equalsIgnoreCase(extendsOrSuper)) {
            wildcard = WildcardKind.EXTENDS;
        }
        if ("super".equalsIgnoreCase(extendsOrSuper)) {
            wildcard = WildcardKind.SUPER;
        }
        if (!(type instanceof TypeReference)) {
            ref = new TypeReference();
            DanglingNodes.addDanglingNode(ref, type);
        } else {
            ref = (TypeReference)type;
        }
        ref.astWildcard(wildcard);
        this.source.registerStructure(ref, qmark);
        for (lombok.ast.libs.org.parboiled.Node childPNode : boundType.getChildren()) {
            if (childPNode == null) continue;
            this.source.registerStructure(ref, childPNode);
        }
        return this.posify(ref);
    }

    public Node createUnboundedWildcardType(lombok.ast.libs.org.parboiled.Node<Node> qmark) {
        TypeReference ref = new TypeReference().astWildcard(WildcardKind.UNBOUND);
        this.source.registerStructure(ref, qmark);
        return this.posify(ref);
    }

    public Node createTypeArguments(Node head, List<Node> tail) {
        TemporaryNode.TypeArguments ta = new TemporaryNode.TypeArguments();
        if (head != null) {
            ta.arguments.add(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                ta.arguments.add(n);
            }
        }
        return this.posify(ta);
    }

    public Node createReferenceType(Node head, List<Node> tail) {
        TypeReference t = new TypeReference();
        if (head != null) {
            t.rawParts().addToEnd(head);
        }
        if (tail != null) {
            for (Node n : tail) {
                if (n == null) continue;
                t.rawParts().addToEnd(n);
            }
        }
        return this.posify(t);
    }

    public Node setArrayDimensionsOfType(Node value, List<String> bracketPairs) {
        int arrayDims;
        int n = arrayDims = bracketPairs == null ? 0 : bracketPairs.size();
        if (arrayDims == 0) {
            return value;
        }
        TypeReference ref = new TypeReference().astArrayDimensions(arrayDims);
        if (value instanceof TypeReference) {
            TypeReference orig = (TypeReference)value;
            ref.astWildcard(orig.astWildcard());
            ref.rawParts().migrateAllFrom(orig.rawParts());
        }
        return this.posify(ref);
    }

    public Node createTypeVariable(Node name, Node head, List<Node> tail) {
        TypeVariable tv = new TypeVariable().astName(this.createIdentifierIfNeeded(name, this.currentPos()));
        if (head != null) {
            tv.rawExtending().addToEnd(head);
        }
        if (tail != null) {
            for (Node t : tail) {
                if (t == null) continue;
                tv.rawExtending().addToEnd(t);
            }
        }
        return this.posify(tv);
    }

    public Node createTypeVariables(Node head, List<Node> tail) {
        TemporaryNode.OrphanedTypeVariables otv = new TemporaryNode.OrphanedTypeVariables();
        if (head != null) {
            otv.variables.add(head);
        }
        if (tail != null) {
            for (Node t : tail) {
                otv.variables.add(t);
            }
        }
        return this.posify(otv);
    }
}

