/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.io.IOException;
import lombok.ast.libs.org.parboiled.asm.AnnotationVisitor;
import lombok.ast.libs.org.parboiled.asm.ClassReader;
import lombok.ast.libs.org.parboiled.asm.MethodVisitor;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.commons.EmptyVisitor;
import lombok.ast.libs.org.parboiled.asm.tree.MethodNode;
import lombok.ast.libs.org.parboiled.support.Checks;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

class ClassNodeInitializer
extends EmptyVisitor
implements Opcodes,
Types {
    private ParserClassNode classNode;
    private Class<?> ownerClass;
    private boolean hasExplicitActionOnlyAnnotation;
    private boolean hasDontLabelAnnotation;
    private boolean hasSkipActionsInPredicates;

    ClassNodeInitializer() {
    }

    public void process(@NotNull ParserClassNode classNode) throws IOException {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ClassNodeInitializer.process(...) corresponds to @NotNull parameter and must not be null");
        }
        this.classNode = classNode;
        this.ownerClass = classNode.getParentClass();
        while (!Object.class.equals(this.ownerClass)) {
            this.hasExplicitActionOnlyAnnotation = false;
            this.hasDontLabelAnnotation = false;
            this.hasSkipActionsInPredicates = false;
            ClassReader classReader = AsmUtils.createClassReader(this.ownerClass);
            classReader.accept(this, 4);
            this.ownerClass = this.ownerClass.getSuperclass();
        }
        for (RuleMethod method : classNode.getRuleMethods().values()) {
            if (!method.isSuperMethod()) break;
            RuleMethod overridingMethod = classNode.getRuleMethods().get(method.name.substring(1) + method.desc);
            method.moveFlagsTo(overridingMethod);
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.ownerClass == this.classNode.getParentClass()) {
            Checks.ensure((access & 2) == 0, "Parser class '%s' must not be private", name);
            Checks.ensure((access & 0x10) == 0, "Parser class '%s' must not be final.", name);
            this.classNode.visit(49, 1, AsmUtils.getExtendedParserClassName(name), null, this.classNode.getParentType().getInternalName(), null);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (EXPLICIT_ACTIONS_ONLY_DESC.equals(desc)) {
            this.hasExplicitActionOnlyAnnotation = true;
            return null;
        }
        if (DONT_LABEL_DESC.equals(desc)) {
            this.hasDontLabelAnnotation = true;
            return null;
        }
        if (SKIP_ACTIONS_IN_PREDICATES_DESC.equals(desc)) {
            this.hasSkipActionsInPredicates = true;
            return null;
        }
        return visible && this.ownerClass == this.classNode.getParentClass() ? this.classNode.visitAnnotation(desc, true) : null;
    }

    public void visitSource(String source, String debug) {
        this.classNode.visitSource(null, null);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            if (this.ownerClass != this.classNode.getParentClass() || (access & 2) > 0) {
                return null;
            }
            MethodNode constructor = new MethodNode(access, name, desc, signature, exceptions);
            this.classNode.getConstructors().add(constructor);
            return constructor;
        }
        if (!Type.getReturnType(desc).equals(RULE) || (access & 0x500) > 0) {
            return null;
        }
        Checks.ensure((access & 2) == 0, "Rule method '%s'must not be private.\nMark the method protected or package-private if you want to prevent public access!", name);
        Checks.ensure((access & 0x10) == 0, "Rule method '%s' must not be final.", name);
        String methodKey = name.concat(desc);
        while (this.classNode.getRuleMethods().containsKey(methodKey)) {
            name = '$' + name;
            methodKey = name.concat(desc);
        }
        RuleMethod method = new RuleMethod(this.ownerClass, access, name, desc, signature, exceptions, this.hasExplicitActionOnlyAnnotation, this.hasDontLabelAnnotation, this.hasSkipActionsInPredicates);
        this.classNode.getRuleMethods().put(methodKey, method);
        return method;
    }

    public void visitEnd() {
        this.classNode.visitEnd();
    }
}

