/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.escape.SimpleEscapingFunction;

public class HtmlEscapeFunction
extends SimpleEscapingFunction {
    private static final char[] ESCAPE_CHARS = new char[]{'<', '>', '&', '\'', '\"'};
    private static final char[] UNQUOTED_ESCAPE_CHARS;
    private static final char[] UNQUOTED_EXTRA_CHARS;
    private static String[] ESCAPE_CODES;

    public HtmlEscapeFunction(boolean isUnquoted) {
        if (isUnquoted) {
            super.setEscapeChars(UNQUOTED_ESCAPE_CHARS);
        } else {
            super.setEscapeChars(ESCAPE_CHARS);
        }
    }

    protected String getEscapeString(char c) {
        if (c < '\u0080') {
            return ESCAPE_CODES[c];
        }
        throw new IllegalArgumentException("Unexpected escape character " + c + "[" + c + "]");
    }

    static {
        UNQUOTED_EXTRA_CHARS = new char[]{'=', ' '};
        ESCAPE_CODES = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "!", "&quot;", "#", "$", "%", "&amp;", "&#39;", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "&lt;", "&#61;", "&gt;", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", ""};
        UNQUOTED_ESCAPE_CHARS = new char[33 + ESCAPE_CHARS.length + UNQUOTED_EXTRA_CHARS.length];
        for (int n = 0; n <= 31; ++n) {
            HtmlEscapeFunction.UNQUOTED_ESCAPE_CHARS[n] = (char)n;
        }
        HtmlEscapeFunction.UNQUOTED_ESCAPE_CHARS[32] = 127;
        System.arraycopy(ESCAPE_CHARS, 0, UNQUOTED_ESCAPE_CHARS, 33, ESCAPE_CHARS.length);
        System.arraycopy(UNQUOTED_EXTRA_CHARS, 0, UNQUOTED_ESCAPE_CHARS, 33 + ESCAPE_CHARS.length, UNQUOTED_EXTRA_CHARS.length);
    }
}

