/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.sdklib.util.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class CommandLineRunner {
    private final ILogger mLogger;

    public CommandLineRunner(ILogger logger) {
        this.mLogger = logger;
    }

    public void runCmdLine(@NonNull List<String> command, @Nullable Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        String[] cmdArray = command.toArray(new String[command.size()]);
        this.runCmdLine(cmdArray, envVariableMap);
    }

    public void runCmdLine(@NonNull String[] command, @Nullable Map<String, String> envVariableMap) throws IOException, InterruptedException, LoggedErrorException {
        OutputGrabber grabber;
        Process process;
        int returnCode;
        this.printCommand(command);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (envVariableMap != null) {
            Map<String, String> env = processBuilder.environment();
            for (Map.Entry<String, String> entry : envVariableMap.entrySet()) {
                env.put(entry.getKey(), entry.getValue());
            }
        }
        if ((returnCode = GrabProcessOutput.grabProcessOutput(process = processBuilder.start(), GrabProcessOutput.Wait.WAIT_FOR_READERS, grabber = new OutputGrabber())) != 0) {
            throw new LoggedErrorException(returnCode, grabber.mErrors, Joiner.on((char)' ').join((Object[])command));
        }
    }

    private void printCommand(String[] command) {
        this.mLogger.info("command: " + Joiner.on((char)' ').join((Object[])command), new Object[0]);
    }

    private class OutputGrabber
    implements GrabProcessOutput.IProcessOutput {
        private boolean mFoundError = false;
        private List<String> mErrors = Lists.newArrayList();

        private OutputGrabber() {
        }

        @Override
        public void out(@Nullable String line) {
            if (line != null) {
                CommandLineRunner.this.mLogger.info(line, new Object[0]);
            }
        }

        @Override
        public void err(@Nullable String line) {
            if (line != null) {
                CommandLineRunner.this.mLogger.error(null, line, new Object[0]);
                this.mErrors.add(line);
                this.mFoundError = true;
            }
        }

        private boolean foundError() {
            return this.mFoundError;
        }
    }
}

