/*
 * Decompiled with CFR 0.152.
 */
package com.android.jobb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class ObbFile {
    public static final int OBB_OVERLAY = 1;
    public static final int OBB_SALTED = 2;
    static final int kFooterTagSize = 8;
    static final int kFooterMinSize = 33;
    static final int kMaxBufSize = 32768;
    static final long kSignature = 17144195L;
    static final int kSigVersion = 1;
    static final int kPackageVersionOffset = 4;
    static final int kFlagsOffset = 8;
    static final int kSaltOffset = 12;
    static final int kPackageNameLenOffset = 20;
    static final int kPackageNameOffset = 24;
    long mPackageVersion = -1L;
    long mFlags;
    String mPackageName;
    byte[] mSalt = new byte[8];

    public boolean readFrom(String filename) {
        File obbFile = new File(filename);
        return this.readFrom(obbFile);
    }

    public boolean readFrom(File obbFile) {
        return this.parseObbFile(obbFile);
    }

    public static long get4LE(ByteBuffer buf) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setSalt(byte[] salt) {
        if (salt.length != this.mSalt.length) {
            throw new RuntimeException("salt must be " + this.mSalt.length + " characters in length");
        }
        System.arraycopy(salt, 0, this.mSalt, 0, this.mSalt.length);
    }

    public void setPackageVersion(long packageVersion) {
        this.mPackageVersion = packageVersion;
    }

    public void setFlags(long flags) {
        this.mFlags = flags;
    }

    public boolean parseObbFile(File obbFile) {
        try {
            long fileLength = obbFile.length();
            if (fileLength < 33L) {
                throw new RuntimeException("file is only " + fileLength + " (less than " + 33 + " minimum)");
            }
            RandomAccessFile raf = new RandomAccessFile(obbFile, "r");
            raf.seek(fileLength - 8L);
            byte[] footer = new byte[8];
            raf.readFully(footer);
            ByteBuffer footBuf = ByteBuffer.wrap(footer);
            footBuf.position(4);
            long fileSig = ObbFile.get4LE(footBuf);
            if (fileSig != 17144195L) {
                throw new RuntimeException("footer didn't match magic string (expected 0x" + Long.toHexString(17144195L) + ";got 0x" + Long.toHexString(fileSig) + ")");
            }
            footBuf.rewind();
            long footerSize = ObbFile.get4LE(footBuf);
            if (footerSize > fileLength - 8L || footerSize > 32768L) {
                throw new RuntimeException("claimed footer size is too large (0x" + Long.toHexString(footerSize) + "; file size is 0x" + Long.toHexString(fileLength) + ")");
            }
            if (footerSize < 25L) {
                throw new RuntimeException("claimed footer size is too small (0x" + Long.toHexString(footerSize) + "; minimum size is 0x" + Long.toHexString(25L));
            }
            long fileOffset = fileLength - footerSize - 8L;
            raf.seek(fileOffset);
            footer = new byte[(int)footerSize];
            raf.readFully(footer);
            footBuf = ByteBuffer.wrap(footer);
            long sigVersion = ObbFile.get4LE(footBuf);
            if (sigVersion != 1L) {
                throw new RuntimeException("Unsupported ObbFile version " + sigVersion);
            }
            footBuf.position(4);
            this.mPackageVersion = ObbFile.get4LE(footBuf);
            footBuf.position(8);
            this.mFlags = ObbFile.get4LE(footBuf);
            footBuf.position(12);
            footBuf.get(this.mSalt);
            footBuf.position(20);
            long packageNameLen = ObbFile.get4LE(footBuf);
            if (packageNameLen == 0L || packageNameLen > footerSize - 24L) {
                throw new RuntimeException("bad ObbFile package name length (0x" + Long.toHexString(packageNameLen) + "; 0x" + Long.toHexString(footerSize - 24L) + "possible)");
            }
            byte[] packageNameBuf = new byte[(int)packageNameLen];
            footBuf.position(24);
            footBuf.get(packageNameBuf);
            this.mPackageName = new String(packageNameBuf);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeTo(String fileName) {
        File obbFile = new File(fileName);
        return this.writeTo(obbFile);
    }

    public boolean writeTo(File obbFile) {
        if (!obbFile.exists()) {
            return false;
        }
        try {
            long fileLength = obbFile.length();
            RandomAccessFile raf = new RandomAccessFile(obbFile, "rw");
            raf.seek(fileLength);
            if (null == this.mPackageName || this.mPackageVersion == -1L) {
                throw new RuntimeException("tried to write uninitialized ObbFile data");
            }
            FileChannel fc = raf.getChannel();
            ByteBuffer bbInt = ByteBuffer.allocate(4);
            bbInt.order(ByteOrder.LITTLE_ENDIAN);
            bbInt.putInt(1);
            bbInt.rewind();
            fc.write(bbInt);
            bbInt.rewind();
            bbInt.putInt((int)this.mPackageVersion);
            bbInt.rewind();
            fc.write(bbInt);
            bbInt.rewind();
            bbInt.putInt((int)this.mFlags);
            bbInt.rewind();
            fc.write(bbInt);
            raf.write(this.mSalt);
            bbInt.rewind();
            bbInt.putInt(this.mPackageName.length());
            bbInt.rewind();
            fc.write(bbInt);
            raf.write(this.mPackageName.getBytes());
            bbInt.rewind();
            bbInt.putInt(this.mPackageName.length() + 24);
            bbInt.rewind();
            fc.write(bbInt);
            bbInt.rewind();
            bbInt.putInt(17144195);
            bbInt.rewind();
            fc.write(bbInt);
            raf.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

