/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.EnumBasedResourceQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceEnum;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DensityQualifier
extends EnumBasedResourceQualifier {
    private static final Pattern sDensityLegacyPattern = Pattern.compile("^(\\d+)dpi$");
    public static final String NAME = "Density";
    private Density mValue = Density.MEDIUM;

    public DensityQualifier() {
    }

    public DensityQualifier(Density value) {
        this.mValue = value;
    }

    public Density getValue() {
        return this.mValue;
    }

    @Override
    ResourceEnum getEnumValue() {
        return this.mValue;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 4;
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        Matcher m;
        Density density = Density.getEnum(value);
        if (density == null && (m = sDensityLegacyPattern.matcher(value)).matches()) {
            String v = m.group(1);
            try {
                density = Density.getEnum(Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (density != null) {
            DensityQualifier qualifier = new DensityQualifier();
            qualifier.mValue = density;
            config.setDensityQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        return qualifier instanceof DensityQualifier;
    }

    @Override
    public boolean isBetterMatchThan(ResourceQualifier compareTo, ResourceQualifier reference) {
        if (compareTo == null) {
            return true;
        }
        DensityQualifier compareQ = (DensityQualifier)compareTo;
        DensityQualifier referenceQ = (DensityQualifier)reference;
        if (compareQ.mValue == referenceQ.mValue) {
            return false;
        }
        if (this.mValue == referenceQ.mValue) {
            return true;
        }
        return this.mValue.getDpiValue() > compareQ.mValue.getDpiValue();
    }
}

