/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import java.text.MessageFormat;

public class CreateSequenceParser {
    public static void parse(PgDatabase database, String statement) {
        Parser parser = new Parser(statement);
        parser.expect("CREATE", "SEQUENCE");
        String sequenceName = parser.parseIdentifier();
        PgSequence sequence = new PgSequence(ParserUtils.getObjectName(sequenceName));
        String schemaName = ParserUtils.getSchemaName(sequenceName, database);
        PgSchema schema = database.getSchema(schemaName);
        if (schema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), schemaName, statement));
        }
        schema.addSequence(sequence);
        while (!parser.expectOptional(";")) {
            if (parser.expectOptional("INCREMENT")) {
                parser.expectOptional("BY");
                sequence.setIncrement(parser.parseString());
                continue;
            }
            if (parser.expectOptional("MINVALUE")) {
                sequence.setMinValue(parser.parseString());
                continue;
            }
            if (parser.expectOptional("MAXVALUE")) {
                sequence.setMaxValue(parser.parseString());
                continue;
            }
            if (parser.expectOptional("START")) {
                parser.expectOptional("WITH");
                sequence.setStartWith(parser.parseString());
                continue;
            }
            if (parser.expectOptional("CACHE")) {
                sequence.setCache(parser.parseString());
                continue;
            }
            if (parser.expectOptional("CYCLE")) {
                sequence.setCycle(true);
                continue;
            }
            if (parser.expectOptional("OWNED", "BY")) {
                if (parser.expectOptional("NONE")) {
                    sequence.setOwnedBy(null);
                    continue;
                }
                sequence.setOwnedBy(ParserUtils.getObjectName(parser.parseIdentifier()));
                continue;
            }
            if (parser.expectOptional("NO")) {
                if (parser.expectOptional("MINVALUE")) {
                    sequence.setMinValue(null);
                    continue;
                }
                if (parser.expectOptional("MAXVALUE")) {
                    sequence.setMaxValue(null);
                    continue;
                }
                if (parser.expectOptional("CYCLE")) {
                    sequence.setCycle(false);
                    continue;
                }
                parser.throwUnsupportedCommand();
                continue;
            }
            parser.throwUnsupportedCommand();
        }
    }

    private CreateSequenceParser() {
    }
}

