/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgConstraint;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgSequence;
import cz.startnet.utils.pgdiff.schema.PgTable;
import cz.startnet.utils.pgdiff.schema.PgView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgSchema {
    private final List<PgFunction> functions = new ArrayList<PgFunction>();
    private final List<PgSequence> sequences = new ArrayList<PgSequence>();
    private final List<PgTable> tables = new ArrayList<PgTable>();
    private final List<PgView> views = new ArrayList<PgView>();
    private final List<PgIndex> indexes = new ArrayList<PgIndex>();
    private final List<PgConstraint> primaryKeys = new ArrayList<PgConstraint>();
    private final String name;
    private String authorization;
    private String definition;
    private String comment;

    public PgSchema(String name) {
        this.name = name;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getCreationSQL() {
        StringBuilder sbSQL = new StringBuilder(50);
        sbSQL.append("CREATE SCHEMA ");
        sbSQL.append(PgDiffUtils.getQuotedName(this.getName()));
        if (this.getAuthorization() != null) {
            sbSQL.append(" AUTHORIZATION ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.getAuthorization()));
        }
        sbSQL.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            sbSQL.append("\n\nCOMMENT ON SCHEMA ");
            sbSQL.append(PgDiffUtils.getQuotedName(this.name));
            sbSQL.append(" IS ");
            sbSQL.append(this.comment);
            sbSQL.append(';');
        }
        return sbSQL.toString();
    }

    public PgFunction getFunction(String signature) {
        for (PgFunction function : this.functions) {
            if (!function.getSignature().equals(signature)) continue;
            return function;
        }
        return null;
    }

    public List<PgFunction> getFunctions() {
        return Collections.unmodifiableList(this.functions);
    }

    public String getName() {
        return this.name;
    }

    public PgIndex getIndex(String name) {
        for (PgIndex index : this.indexes) {
            if (!index.getName().equals(name)) continue;
            return index;
        }
        return null;
    }

    public PgConstraint getPrimaryKey(String name) {
        for (PgConstraint constraint : this.primaryKeys) {
            if (!constraint.getName().equals(name)) continue;
            return constraint;
        }
        return null;
    }

    public PgSequence getSequence(String name) {
        for (PgSequence sequence : this.sequences) {
            if (!sequence.getName().equals(name)) continue;
            return sequence;
        }
        return null;
    }

    public List<PgIndex> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public List<PgConstraint> getPrimaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public List<PgSequence> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    public PgTable getTable(String name) {
        for (PgTable table : this.tables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public List<PgTable> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public PgView getView(String name) {
        for (PgView view : this.views) {
            if (!view.getName().equals(name)) continue;
            return view;
        }
        return null;
    }

    public List<PgView> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public void addIndex(PgIndex index) {
        this.indexes.add(index);
    }

    public void addPrimaryKey(PgConstraint primaryKey) {
        this.primaryKeys.add(primaryKey);
    }

    public void addFunction(PgFunction function) {
        this.functions.add(function);
    }

    public void addSequence(PgSequence sequence) {
        this.sequences.add(sequence);
    }

    public void addTable(PgTable table) {
        this.tables.add(table);
    }

    public void addView(PgView view) {
        this.views.add(view);
    }

    public boolean containsFunction(String signature) {
        for (PgFunction function : this.functions) {
            if (!function.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSequence(String name) {
        for (PgSequence sequence : this.sequences) {
            if (!sequence.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTable(String name) {
        for (PgTable table : this.tables) {
            if (!table.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsView(String name) {
        for (PgView view : this.views) {
            if (!view.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

