/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.csv;

import org.basex.core.BaseXException;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumbersOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.ValueOption;

public class CsvOptions
extends Options {
    public static final StringOption SEPARATOR = new StringOption("separator", ",");
    public static final StringOption FIELD_DELIMITER = new StringOption("field-delimiter");
    public static final EnumOption<CsvFormat> FORMAT = new EnumOption<CsvFormat>("format", CsvFormat.DIRECT);
    public static final ValueOption HEADER = new ValueOption("header", SeqType.ITEM_ZM, Bln.FALSE);
    public static final BooleanOption BACKSLASHES = new BooleanOption("backslashes", false);
    public static final BooleanOption LAX = new BooleanOption("lax", true);
    public static final BooleanOption QUOTES = new BooleanOption("quotes", true);
    public static final StringOption ROW_DELIMITER = new StringOption("row-delimiter", "\n");
    public static final StringOption QUOTE_CHARACTER = new StringOption("quote-character", "\"");
    public static final BooleanOption TRIM_WHITESPACE = new BooleanOption("trim-whitespace", false);
    public static final BooleanOption STRICT_QUOTING = new BooleanOption("strict-quoting", false);
    public static final BooleanOption TRIM_ROWS = new BooleanOption("trim-rows", false);
    public static final NumbersOption SELECT_COLUMNS = new NumbersOption("select-columns", new int[0]);

    @Override
    public synchronized void assign(String name, String value) throws BaseXException {
        super.assign(name, value);
        try {
            this.validate(null);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex.getLocalizedMessage(), new Object[0]);
        }
    }

    @Override
    public synchronized void assign(Item name, Value value, InputInfo info) throws QueryException {
        super.assign(name, value, info);
        this.validate(info);
    }

    private void validate(InputInfo info) throws QueryException {
        StringOption option;
        StringOption separator = this.get(FIELD_DELIMITER) != null ? FIELD_DELIMITER : SEPARATOR;
        int f = this.fieldDelimiter();
        int r = this.rowDelimiter();
        int q = this.quoteCharacter();
        StringOption stringOption = f == -1 ? separator : (r == -1 ? ROW_DELIMITER : (option = q == -1 ? QUOTE_CHARACTER : null));
        if (option != null) {
            throw QueryError.CSV_SINGLECHAR_X_X.get(info, option.name(), this.get(option));
        }
        if (f == q || r == f || q == r) {
            throw QueryError.CSV_DELIMITER_X.get(info, this.get(f == q || r == f ? separator : QUOTE_CHARACTER));
        }
    }

    public int fieldDelimiter() {
        CsvSep s;
        String sep = this.get(FIELD_DELIMITER);
        if (sep == null && (s = Enums.get(CsvSep.class, sep = this.get(SEPARATOR))) != null) {
            return s.sep;
        }
        return CsvOptions.checkCodepoint(sep);
    }

    public int rowDelimiter() {
        return CsvOptions.checkCodepoint(this.get(ROW_DELIMITER));
    }

    public int quoteCharacter() {
        return CsvOptions.checkCodepoint(this.get(QUOTE_CHARACTER));
    }

    private static int checkCodepoint(String single) {
        int cp;
        if (single.codePointCount(0, single.length()) == 1 && XMLToken.valid(cp = single.codePointAt(0))) {
            return cp;
        }
        return -1;
    }

    public CsvOptions() {
    }

    public CsvOptions(CsvOptions opts) {
        super(opts);
    }

    public static enum CsvSep {
        COMMA(','),
        SEMICOLON(';'),
        COLON(':'),
        TAB('\t'),
        SPACE(' ');

        public final char sep;

        private CsvSep(char sep) {
            this.sep = sep;
        }

        public String toString() {
            return Enums.string(this);
        }
    }

    public static enum CsvFormat {
        DIRECT,
        ATTRIBUTES,
        W3,
        W3_ARRAYS,
        W3_XML,
        XQUERY;


        public String toString() {
            return Enums.string(this);
        }
    }
}

