/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Convert;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Cast
extends Convert {
    public Cast(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, seqType, SeqType.ITEM_ZM);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        super.optimize(cc);
        if ((Function.ZERO_OR_ONE.is(this.expr) || Function.EXACTLY_ONE.is(this.expr) || Function.ONE_OR_MORE.is(this.expr)) && this.seqType.occ.instanceOf(this.expr.seqType().occ)) {
            this.expr = this.expr.arg(0);
        }
        SeqType st = this.castType();
        this.exprType.assign(st);
        Boolean test = this.castable(st);
        if (test == Boolean.FALSE) {
            throw QueryError.typeError(this.expr, this.seqType, this.info);
        }
        if (test == Boolean.TRUE) {
            return cc.replaceWith(this, this.expr);
        }
        Expr arg = this.simplify(st, cc);
        if (arg != null) {
            return new Cast(this.info, arg, this.seqType).optimize(cc);
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.seqType.cast(this.expr.atomValue(qc, this.info), true, qc, this.info);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return this.simplifyForCast(mode, cc);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Cast(this.info, this.expr.copy(cc, vm), this.seqType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Cast)) return false;
        Cast cst = (Cast)obj;
        if (!this.seqType.eq(cst.seqType)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toString(QueryString qs) {
        if (this.seqType.one()) {
            qs.token("(").token(this.expr).token("cast").token("as").token(this.seqType).token(')');
        } else {
            qs.token(this.seqType.type).paren(this.expr);
        }
    }
}

