/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryBiFunction;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ALookup;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public final class Lookup
extends ALookup {
    public Lookup(InputInfo info, ALookup.Modifier modifier, Expr ... expr) {
        super(info, modifier, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.exprs[1] = this.exprs[1].simplifyFor(CompileContext.Simplify.DATA, cc);
        Expr inputs = this.exprs[0];
        long is = inputs.size();
        if (is == 0L) {
            return cc.replaceWith(this, inputs);
        }
        Type tp = inputs.seqType().type;
        boolean map = tp instanceof MapType;
        boolean array = tp instanceof ArrayType;
        if (!map && !array) {
            return this;
        }
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        Expr keys = this.exprs[1];
        SeqType kt = keys.seqType();
        SeqType st = map ? ((MapType)tp).valueType() : ((ArrayType)tp).valueType();
        Occ occ = st.occ;
        if (inputs.size() != 1L || keys == WILDCARD || !kt.one() || kt.mayBeArray()) {
            occ = occ.union(Occ.ZERO_OR_MORE);
        } else if (map) {
            occ = occ.union(Occ.ZERO);
        }
        this.exprType.assign(st.mayBeFunction() ? AtomType.ITEM : st.type, occ);
        return this;
    }

    private Expr opt(CompileContext cc) throws QueryException {
        long ks;
        Expr input = this.exprs[0];
        Expr keys = this.exprs[1];
        long is = input.size();
        long l = ks = keys.seqType().mayBeArray() || keys.has(Flag.NDT) ? -1L : keys.size();
        if (ks == 0L) {
            return keys;
        }
        Type it = input.seqType().type;
        boolean map = it instanceof MapType;
        boolean array = it instanceof ArrayType;
        if ((map || array) && (this.modifier == ALookup.Modifier.ITEMS || keys == WILDCARD && map && (this.modifier == ALookup.Modifier.KEYS || this.modifier == ALookup.Modifier.PAIRS))) {
            QueryBiFunction<Expr, Expr, Expr> rewrite = (in, arg) -> {
                if (this.modifier == ALookup.Modifier.ITEMS) {
                    return keys == WILDCARD ? (map ? cc.function(Function._MAP_ITEMS, this.info, (Expr)in) : cc.function(Function._ARRAY_ITEMS, this.info, (Expr)in)) : (map ? cc.function(Function._MAP_GET, this.info, (Expr)in, (Expr)arg, Empty.UNDEFINED, Bln.TRUE) : cc.function(Function._ARRAY_GET, this.info, (Expr)in, (Expr)arg, Empty.VALUE));
                }
                if (map && keys == WILDCARD) {
                    if (this.modifier == ALookup.Modifier.KEYS) {
                        return cc.function(Function._MAP_KEYS, this.info, (Expr)in);
                    }
                    if (this.modifier == ALookup.Modifier.PAIRS) {
                        return cc.function(Function._MAP_PAIRS, this.info, (Expr)in);
                    }
                }
                throw Util.notExpected();
            };
            if (ks == 1L) {
                if (is == 1L) {
                    return rewrite.apply(input, keys);
                }
                return SimpleMap.get(cc, this.info, input, cc.get(input, true, () -> (Expr)rewrite.apply(ContextValue.get(cc, this.info), keys)));
            }
            if (ks != -1L && (input instanceof Value || input instanceof VarRef)) {
                if (is == 1L) {
                    return SimpleMap.get(cc, this.info, keys, cc.get(keys, true, () -> (Expr)rewrite.apply(input, ContextValue.get(cc, this.info))));
                }
                Var var = cc.vs().addNew(new QNm("item"), null, cc.qc, this.info);
                For fr = new For(var, input).optimize(cc);
                Expr ex = cc.get(keys, true, () -> (Expr)rewrite.apply(new VarRef(this.info, var).optimize(cc), ContextValue.get(cc, this.info)));
                return new GFLWOR(this.info, fr, SimpleMap.get(cc, this.info, keys, ex)).optimize(cc);
            }
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        return new Iter(){
            final Iter iter;
            Iter ir;
            {
                this.iter = Lookup.this.exprs[0].iter(qc);
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.ir == null || (item = qc.next(this.ir)) == null) {
                    item = qc.next(this.iter);
                    if (item == null) {
                        return null;
                    }
                    this.ir = Lookup.this.valueFor(item, false, qc).iter();
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        ValueBuilder vb = new ValueBuilder(qc);
        Iter iter = this.exprs[0].iter(qc);
        while ((item = qc.next(iter)) != null) {
            vb.add(this.valueFor(item, false, qc));
        }
        return vb.value(this);
    }

    @Override
    public Lookup copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Lookup(this.info, this.modifier, Lookup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Lookup && super.equals(obj);
    }
}

