/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Token;

abstract class FileFn
extends StandardFunc {
    private static final byte[] NL = Token.token(Prop.NL);

    FileFn() {
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        try {
            return this.item(qc);
        }
        catch (NoSuchFileException ex) {
            throw QueryError.FILE_NOT_FOUND_X.get(this.info, ex);
        }
        catch (AccessDeniedException ex) {
            throw QueryError.FILE_IE_ERROR_ACCESS_X.get(this.info, ex);
        }
        catch (FileAlreadyExistsException ex) {
            throw QueryError.FILE_EXISTS_X.get(this.info, ex);
        }
        catch (DirectoryNotEmptyException ex) {
            throw QueryError.FILE_ID_DIR2_X.get(this.info, ex);
        }
        catch (IOException ex) {
            throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
        }
    }

    public Item item(QueryContext qc) throws QueryException, IOException {
        return super.item(qc, null);
    }

    final Path toParent(Path path) throws QueryException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw QueryError.FILE_IS_DIR_X.get(this.info, path.toAbsolutePath());
        }
        Path parent = path.getParent();
        if (parent != null && !Files.exists(parent, new LinkOption[0])) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, parent.toAbsolutePath());
        }
        return path;
    }

    final void write(boolean append, boolean lines, QueryContext qc) throws QueryException, IOException {
        block18: {
            Path path = this.toParent(this.toPath(this.arg(0), qc));
            String encoding = this.toEncodingOrNull(this.arg(2), QueryError.FILE_UNKNOWN_ENCODING_X, qc);
            Charset cs = encoding == null || encoding == "UTF-8" ? null : Charset.forName(encoding);
            try (PrintOutput out = PrintOutput.get(new FileOutputStream(path.toFile(), append));){
                if (lines) {
                    Item item;
                    Iter values = this.arg(1).iter(qc);
                    while ((item = qc.next(values)) != null) {
                        if (!item.type.isStringOrUntyped()) {
                            throw QueryError.typeError(item, AtomType.STRING, this.info);
                        }
                        byte[] token = item.string(this.info);
                        out.write(cs == null ? token : Token.string(token).getBytes(cs));
                        out.write(cs == null ? NL : Prop.NL.getBytes(cs));
                    }
                    break block18;
                }
                Item value = this.toAtomItem(this.arg(1), qc);
                if (!(value instanceof AStr)) {
                    value = Str.get(this.toToken(value));
                }
                if (cs == null) {
                    try (TextInput in = value.stringInput(this.info);){
                        int cp;
                        while ((cp = in.read()) != -1) {
                            out.print(cp);
                        }
                        break block18;
                    }
                }
                out.write(Token.string(value.string(this.info)).getBytes(cs));
            }
        }
    }

    static Str get(Path path, boolean dir) {
        String string = path.toString();
        return Str.get((String)(dir && !string.endsWith(File.separator) ? string + File.separator : string));
    }

    static Path absolute(Path path) {
        return path.toAbsolutePath().normalize();
    }
}

