/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.fn.DateTimeFn;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class FnCivilTimezone
extends DateTimeFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ZoneId id;
        Dtm value = (Dtm)this.checkType(this.arg(0), AtomType.DATE_TIME, qc);
        String place = this.toStringOrNull(this.arg(1), qc);
        Instant instant = value.toJava().toGregorianCalendar().toInstant();
        try {
            id = place != null ? ZoneId.of(place) : ZoneId.systemDefault();
        }
        catch (RuntimeException ex) {
            Util.debug(ex);
            throw QueryError.PLACE_X.get(this.info, place);
        }
        return DTDur.get((long)ZonedDateTime.ofInstant(instant, id).getOffset().getTotalSeconds() * 1000L);
    }
}

