/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.impl.operations.ChangeClusterStateOperation;
import com.hazelcast.cluster.impl.operations.LockClusterStateOperation;
import com.hazelcast.cluster.impl.operations.RollbackClusterStateOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.TargetAwareTransactionLogRecord;
import com.hazelcast.util.Preconditions;
import java.io.IOException;

public class ClusterStateTransactionLogRecord
implements TargetAwareTransactionLogRecord {
    private ClusterState newState;
    private Address initiator;
    private Address target;
    private String txnId;
    private long leaseTime;
    private int partitionStateVersion;

    public ClusterStateTransactionLogRecord() {
    }

    public ClusterStateTransactionLogRecord(ClusterState newState, Address initiator, Address target, String txnId, long leaseTime, int partitionStateVersion) {
        Preconditions.checkNotNull(newState);
        Preconditions.checkNotNull(initiator);
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(txnId);
        Preconditions.checkPositive(leaseTime, "Lease time should be positive!");
        this.newState = newState;
        this.initiator = initiator;
        this.target = target;
        this.txnId = txnId;
        this.leaseTime = leaseTime;
        this.partitionStateVersion = partitionStateVersion;
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public Operation newPrepareOperation() {
        return new LockClusterStateOperation(this.newState, this.initiator, this.txnId, this.leaseTime, this.partitionStateVersion);
    }

    @Override
    public Operation newCommitOperation() {
        return new ChangeClusterStateOperation(this.newState, this.initiator, this.txnId);
    }

    @Override
    public Operation newRollbackOperation() {
        return new RollbackClusterStateOperation(this.initiator, this.txnId);
    }

    @Override
    public Address getTarget() {
        return this.target;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.newState.toString());
        this.initiator.writeData(out);
        this.target.writeData(out);
        out.writeUTF(this.txnId);
        out.writeLong(this.leaseTime);
        out.writeInt(this.partitionStateVersion);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        String stateName = in.readUTF();
        this.newState = ClusterState.valueOf(stateName);
        this.initiator = new Address();
        this.initiator.readData(in);
        this.target = new Address();
        this.target.readData(in);
        this.txnId = in.readUTF();
        this.leaseTime = in.readLong();
        this.partitionStateVersion = in.readInt();
    }
}

