/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txncollection;

import com.hazelcast.collection.impl.txncollection.TransactionLogRecordKey;
import com.hazelcast.collection.impl.txncollection.operations.CollectionPrepareOperation;
import com.hazelcast.collection.impl.txncollection.operations.CollectionRollbackOperation;
import com.hazelcast.collection.impl.txncollection.operations.CollectionTxnRemoveOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.TransactionLogRecord;
import java.io.IOException;

public class CollectionTransactionLogRecord
implements TransactionLogRecord {
    private String transactionId;
    private long itemId;
    private String name;
    private Operation op;
    private int partitionId;
    private String serviceName;

    public CollectionTransactionLogRecord() {
    }

    public CollectionTransactionLogRecord(long itemId, String name, int partitionId, String serviceName, String transactionId, Operation op) {
        this.itemId = itemId;
        this.name = name;
        this.op = op;
        this.partitionId = partitionId;
        this.serviceName = serviceName;
        this.transactionId = transactionId;
    }

    @Override
    public Object getKey() {
        return new TransactionLogRecordKey(this.name, this.itemId, this.serviceName);
    }

    @Override
    public Operation newPrepareOperation() {
        boolean removeOperation = this.op instanceof CollectionTxnRemoveOperation;
        return new CollectionPrepareOperation(this.partitionId, this.name, this.serviceName, this.itemId, this.transactionId, removeOperation);
    }

    @Override
    public Operation newCommitOperation() {
        this.op.setServiceName(this.serviceName);
        this.op.setPartitionId(this.partitionId);
        return this.op;
    }

    @Override
    public Operation newRollbackOperation() {
        boolean removeOperation = this.op instanceof CollectionTxnRemoveOperation;
        return new CollectionRollbackOperation(this.partitionId, this.name, this.serviceName, this.itemId, removeOperation);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.itemId);
        out.writeUTF(this.name);
        out.writeInt(this.partitionId);
        out.writeUTF(this.serviceName);
        out.writeObject(this.op);
        out.writeUTF(this.transactionId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.itemId = in.readLong();
        this.name = in.readUTF();
        this.partitionId = in.readInt();
        this.serviceName = in.readUTF();
        this.op = (Operation)in.readObject();
        this.transactionId = in.readUTF();
    }

    public String toString() {
        return "CollectionTransactionLogRecord{transactionId='" + this.transactionId + '\'' + ", itemId=" + this.itemId + ", name='" + this.name + '\'' + ", op=" + this.op + ", partitionId=" + this.partitionId + ", serviceName='" + this.serviceName + '\'' + '}';
    }
}

