/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AsyncResponsePacketHandler
implements PacketHandler {
    private final ResponseThread responseThread;
    private final BlockingQueue<Packet> workQueue = new LinkedBlockingQueue<Packet>();
    private final ILogger logger;

    public AsyncResponsePacketHandler(HazelcastThreadGroup threadGroup, ILogger logger, PacketHandler responsePacketHandler) {
        this.logger = logger;
        this.responseThread = new ResponseThread(threadGroup, responsePacketHandler);
        this.responseThread.start();
    }

    public int getQueueSize() {
        return this.workQueue.size();
    }

    public void shutdown() {
        this.responseThread.shutdown();
    }

    @Override
    public void handle(Packet packet) {
        Preconditions.checkNotNull(packet, "packet can't be null");
        Preconditions.checkTrue(packet.isHeaderSet(0), "HEADER_OP should be set");
        Preconditions.checkTrue(packet.isHeaderSet(1), "HEADER_RESPONSE should be set");
        this.workQueue.add(packet);
    }

    private final class ResponseThread
    extends Thread
    implements OperationHostileThread {
        volatile long processedResponses;
        private final PacketHandler responsePacketHandler;
        private volatile boolean shutdown;

        public ResponseThread(HazelcastThreadGroup threadGroup, PacketHandler responsePacketHandler) {
            super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix("response"));
            this.setContextClassLoader(threadGroup.getClassLoader());
            this.responsePacketHandler = responsePacketHandler;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
                AsyncResponsePacketHandler.this.logger.severe(t);
            }
        }

        private void doRun() {
            while (true) {
                Packet responsePacket;
                try {
                    responsePacket = (Packet)AsyncResponsePacketHandler.this.workQueue.take();
                }
                catch (InterruptedException e) {
                    if (!this.shutdown) continue;
                    return;
                }
                if (this.shutdown) {
                    return;
                }
                this.process(responsePacket);
            }
        }

        @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
        private void process(Packet responsePacket) {
            ++this.processedResponses;
            try {
                this.responsePacketHandler.handle(responsePacket);
            }
            catch (Throwable e) {
                OutOfMemoryErrorDispatcher.inspectOutputMemoryError(e);
                AsyncResponsePacketHandler.this.logger.severe("Failed to process response: " + responsePacket + " on response thread:" + this.getName(), e);
            }
        }

        private void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }
    }
}

