/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Platform;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class ObjectArraySubject<T>
extends AbstractArraySubject<ObjectArraySubject<T>, T[]> {
    private final String typeName;
    private final int numberOfDimensions;
    private static final Function<Object, Object> STRINGIFY = new Function<Object, Object>(){

        public Object apply(@Nullable Object input) {
            if (input != null && input.getClass().isArray()) {
                List<Object> iterable = input.getClass() == boolean[].class ? Booleans.asList((boolean[])((boolean[])input)) : (input.getClass() == int[].class ? Ints.asList((int[])((int[])input)) : (input.getClass() == long[].class ? Longs.asList((long[])((long[])input)) : (input.getClass() == short[].class ? Shorts.asList((short[])((short[])input)) : (input.getClass() == byte[].class ? Bytes.asList((byte[])((byte[])input)) : (input.getClass() == double[].class ? Doubles.asList((double[])((double[])input)) : (input.getClass() == float[].class ? Floats.asList((float[])((float[])input)) : (input.getClass() == char[].class ? Chars.asList((char[])((char[])input)) : Arrays.asList((Object[])input))))))));
                return Iterables.transform((Iterable)iterable, (Function)STRINGIFY);
            }
            return input;
        }
    };

    ObjectArraySubject(FailureMetadata metadata, @Nullable T[] o) {
        super(metadata, o);
        this.typeName = ObjectArraySubject.typeNameFromInstance(o);
        this.numberOfDimensions = ObjectArraySubject.numberOfDimensions(o);
    }

    @Override
    protected String underlyingType() {
        return this.typeName;
    }

    @Override
    String brackets() {
        return Strings.repeat((String)"[]", (int)this.numberOfDimensions);
    }

    @Override
    protected List<?> listRepresentation() {
        return Lists.newArrayList(ObjectArraySubject.stringableIterable((Object[])this.actual()));
    }

    private static Iterable<?> stringableIterable(Object[] array) {
        return Iterables.transform(Arrays.asList(array), STRINGIFY);
    }

    private static String typeNameFromInstance(Object instance) {
        if (instance == null) {
            return "null reference of unknown array type";
        }
        if (!instance.getClass().isArray()) {
            throw new IllegalArgumentException(instance.getClass().getName() + " instance passed into T[] subject.");
        }
        Class<?> type = instance.getClass().getComponentType();
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Primitive array passed into T[] subject.");
        }
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return Platform.compressType(type.toString());
    }

    private static int numberOfDimensions(Object instance) {
        if (instance == null) {
            return 0;
        }
        Class<?> type = instance.getClass();
        int dimensions = 0;
        while (type.isArray()) {
            ++dimensions;
            type = type.getComponentType();
        }
        return dimensions;
    }

    @Override
    public void isEqualTo(Object expected) {
        Object[] actual = (Object[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            Object[] expectedArray = (Object[])expected;
            if (actual.length != expectedArray.length) {
                this.failWithRawMessage("%s has length %s. Expected length is %s", this.actualAsString(), actual.length, expectedArray.length);
            } else {
                String index = this.checkArrayEqualsRecursive(expectedArray, actual, "");
                if (index != null) {
                    this.failWithBadResults("is equal to", ObjectArraySubject.stringableIterable(expectedArray), "differs at index", index);
                }
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Nullable
    private String checkArrayEqualsRecursive(Object expectedArray, Object actualArray, String lastIndex) {
        int actualLength = Platform.getArrayLength(actualArray);
        int expectedLength = Platform.getArrayLength(expectedArray);
        for (int i = 0; i < actualLength || i < expectedLength; ++i) {
            String index = lastIndex + "[" + i + "]";
            if (i < expectedLength && i < actualLength) {
                Object expected = Platform.getFromArray(expectedArray, i);
                Object actual = Platform.getFromArray(actualArray, i);
                if (actual != null && actual.getClass().isArray() && expected != null && expected.getClass().isArray()) {
                    String result = this.checkArrayEqualsRecursive(expected, actual, index);
                    if (result == null) continue;
                    return result;
                }
                if (Objects.equal((Object)actual, (Object)expected)) continue;
            }
            return index;
        }
        return null;
    }

    @Override
    public void isNotEqualTo(Object expected) {
        Object[] actual = (Object[])this.actual();
        try {
            Object[] expectedArray = (Object[])expected;
            if (actual == expected || this.checkArrayEqualsRecursive(expectedArray, actual, "") == null) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), ObjectArraySubject.stringableIterable(expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public IterableSubject asList() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(Arrays.asList((Object[])this.actual())).named(this.internalCustomName(), new Object[0]) : this.check().that(Arrays.asList((Object[])this.actual()));
    }
}

