/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.truth.AbstractFailureStrategy;
import com.google.common.truth.AtomicLongMapSubject;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.CustomSubjectBuilder;
import com.google.common.truth.CustomSubjectBuilderFactory;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListMultimapSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.Platform;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SetMultimapSubject;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.SortedMapSubject;
import com.google.common.truth.SortedSetSubject;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TableSubject;
import com.google.common.truth.ThrowableSubject;
import com.google.common.util.concurrent.AtomicLongMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

public final class Truth {
    @Deprecated
    public static final FailureStrategy THROW_ASSERTION_ERROR = new AbstractFailureStrategy(){

        @Override
        public void fail(String message, Throwable cause) {
            throw this.stripFramesAndTryToAddCause(new AssertionError((Object)message), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual, @Nullable Throwable cause) {
            AssertionError e = Platform.comparisonFailure(message, expected.toString(), actual.toString());
            throw this.stripFramesAndTryToAddCause(e, cause);
        }

        private AssertionError stripFramesAndTryToAddCause(AssertionError failure, @Nullable Throwable cause) {
            if (cause != null) {
                try {
                    ((Throwable)((Object)failure)).initCause(cause);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return 1.stripTruthStackFrames(failure);
        }
    };
    private static final StandardSubjectBuilder ASSERT = StandardSubjectBuilder.forCustomFailureStrategy(THROW_ASSERTION_ERROR);

    private Truth() {
    }

    public static StandardSubjectBuilder assert_() {
        return ASSERT;
    }

    public static StandardSubjectBuilder assertWithMessage(String messageToPrepend) {
        return Truth.assert_().withMessage(messageToPrepend);
    }

    public static StandardSubjectBuilder assertWithMessage(String format, Object ... args) {
        return Truth.assert_().withMessage(format, args);
    }

    @Deprecated
    public static <S extends Subject<S, T>, T> SimpleSubjectBuilder<S, T> assertAbout(SubjectFactory<S, T> factory) {
        return Truth.assert_().about(factory);
    }

    public static <S extends Subject<S, T>, T> SimpleSubjectBuilder<S, T> assertAbout(Subject.Factory<S, T> factory) {
        return Truth.assert_().about(factory);
    }

    @Deprecated
    public static <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT assertAbout(CustomSubjectBuilderFactory<CustomSubjectBuilderT> factory) {
        return Truth.assert_().about(factory);
    }

    public static <CustomSubjectBuilderT extends CustomSubjectBuilder> CustomSubjectBuilderT assertAbout(CustomSubjectBuilder.Factory<CustomSubjectBuilderT> factory) {
        return Truth.assert_().about(factory);
    }

    public static <T extends Comparable<?>> ComparableSubject<?, T> assertThat(@Nullable T actual) {
        return Truth.assert_().that(actual);
    }

    public static BigDecimalSubject assertThat(@Nullable BigDecimal actual) {
        return Truth.assert_().that(actual);
    }

    public static Subject<DefaultSubject, Object> assertThat(@Nullable Object actual) {
        return Truth.assert_().that(actual);
    }

    @GwtIncompatible(value="ClassSubject.java")
    public static ClassSubject assertThat(@Nullable Class<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static ThrowableSubject assertThat(@Nullable Throwable actual) {
        return Truth.assert_().that(actual);
    }

    public static LongSubject assertThat(@Nullable Long actual) {
        return Truth.assert_().that(actual);
    }

    public static DoubleSubject assertThat(@Nullable Double actual) {
        return Truth.assert_().that(actual);
    }

    public static FloatSubject assertThat(@Nullable Float actual) {
        return Truth.assert_().that(actual);
    }

    public static IntegerSubject assertThat(@Nullable Integer actual) {
        return Truth.assert_().that(actual);
    }

    public static BooleanSubject assertThat(@Nullable Boolean actual) {
        return Truth.assert_().that(actual);
    }

    public static StringSubject assertThat(@Nullable String actual) {
        return Truth.assert_().that(actual);
    }

    public static IterableSubject assertThat(@Nullable Iterable<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static SortedSetSubject assertThat(@Nullable SortedSet<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static <T> ObjectArraySubject<T> assertThat(@Nullable T[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveBooleanArraySubject assertThat(@Nullable boolean[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveShortArraySubject assertThat(@Nullable short[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveIntArraySubject assertThat(@Nullable int[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveLongArraySubject assertThat(@Nullable long[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveByteArraySubject assertThat(@Nullable byte[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveCharArraySubject assertThat(@Nullable char[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveFloatArraySubject assertThat(@Nullable float[] actual) {
        return Truth.assert_().that(actual);
    }

    public static PrimitiveDoubleArraySubject assertThat(@Nullable double[] actual) {
        return Truth.assert_().that(actual);
    }

    public static GuavaOptionalSubject assertThat(@Nullable Optional<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MapSubject assertThat(@Nullable Map<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static SortedMapSubject assertThat(@Nullable SortedMap<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MultimapSubject assertThat(@Nullable Multimap<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static ListMultimapSubject assertThat(@Nullable ListMultimap<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static SetMultimapSubject assertThat(@Nullable SetMultimap<?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static MultisetSubject assertThat(@Nullable Multiset<?> actual) {
        return Truth.assert_().that(actual);
    }

    public static TableSubject assertThat(@Nullable Table<?, ?, ?> actual) {
        return Truth.assert_().that(actual);
    }

    public static AtomicLongMapSubject assertThat(@Nullable AtomicLongMap<?> actual) {
        return Truth.assert_().that(actual);
    }
}

