/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.bugpatterns.formatstring.FormatStringValidation;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

public class StrictFormatStringValidation {
    private static final Matcher<ExpressionTree> MOCKITO_ARGUMENT_MATCHER = MethodMatchers.staticMethod().onClass("org.mockito.Matchers");

    @Nullable
    public static FormatStringValidation.ValidationResult validate(ExpressionTree formatStringTree, List<? extends ExpressionTree> args, VisitorState state) {
        if (MOCKITO_ARGUMENT_MATCHER.matches((Tree)formatStringTree, state)) {
            return null;
        }
        String formatStringValue = (String)ASTHelpers.constValue((Tree)formatStringTree, String.class);
        if (formatStringValue != null) {
            return FormatStringValidation.validate((Collection<? extends ExpressionTree>)ImmutableList.builder().add((Object)formatStringTree).addAll(args).build(), state);
        }
        Symbol formatStringSymbol = ASTHelpers.getSymbol((Tree)formatStringTree);
        if (!(formatStringSymbol instanceof Symbol.VarSymbol)) {
            return FormatStringValidation.ValidationResult.create(null, String.format("Format strings must be either a literal or a variable. Other expressions are not valid.\nInvalid format string: %s", formatStringTree));
        }
        if ((formatStringSymbol.flags() & 0x20000000010L) == 0L) {
            return FormatStringValidation.ValidationResult.create(null, "All variables passed as @FormatString must be final or effectively final");
        }
        if (formatStringSymbol.getKind() == ElementKind.PARAMETER) {
            return StrictFormatStringValidation.validateFormatStringParamter(formatStringTree, formatStringSymbol, args, state);
        }
        return StrictFormatStringValidation.validateFormatStringVariable(formatStringTree, formatStringSymbol, args, state);
    }

    /*
     * WARNING - void declaration
     */
    private static FormatStringValidation.ValidationResult validateFormatStringParamter(ExpressionTree formatStringTree, Symbol formatStringSymbol, List<? extends ExpressionTree> args, VisitorState state) {
        void var11_13;
        if (!StrictFormatStringValidation.isFormatStringParameter(formatStringSymbol, state)) {
            return FormatStringValidation.ValidationResult.create(null, String.format("Format strings must be compile time constant or parameters annotated @FormatString: %s", formatStringTree));
        }
        List ownerParams = ((Symbol.MethodSymbol)formatStringSymbol.owner).getParameters();
        int ownerFormatStringIndex = ownerParams.indexOf(formatStringSymbol);
        ImmutableList.Builder ownerFormatArgTypesBuilder = ImmutableList.builder();
        for (Symbol.VarSymbol paramSymbol : ownerParams.subList(ownerFormatStringIndex + 1, ownerParams.size())) {
            ownerFormatArgTypesBuilder.add((Object)paramSymbol.type);
        }
        ImmutableList ownerFormatArgTypes = ownerFormatArgTypesBuilder.build();
        Types types = state.getTypes();
        ImmutableList.Builder calleeFormatArgTypesBuilder = ImmutableList.builder();
        for (ExpressionTree expressionTree : args) {
            calleeFormatArgTypesBuilder.add((Object)types.erasure(((JCTree.JCExpression)expressionTree).type));
        }
        ImmutableList calleeFormatArgTypes = calleeFormatArgTypesBuilder.build();
        if (ownerFormatArgTypes.size() != calleeFormatArgTypes.size()) {
            return FormatStringValidation.ValidationResult.create(null, String.format("The number of format arguments passed with an @FormatString must match the number of format arguments in the @FormatMethod header where the format string was declared.\n\tFormat args passed: %d\n\tFormat args expected: %d", calleeFormatArgTypes.size(), ownerFormatArgTypes.size()));
        }
        boolean bl = false;
        while (var11_13 < calleeFormatArgTypes.size()) {
            if (!ASTHelpers.isSameType((Type)((Type)ownerFormatArgTypes.get((int)var11_13)), (Type)((Type)calleeFormatArgTypes.get((int)var11_13)), (VisitorState)state)) {
                return FormatStringValidation.ValidationResult.create(null, String.format("The format argument types passed with an @FormatString must match the types of the format arguments in the @FormatMethod header where the format string was declared.\n\tFormat arg types passed: %s\n\tFormat arg types expected: %s", calleeFormatArgTypes.toArray(), ownerFormatArgTypes.toArray()));
            }
            ++var11_13;
        }
        return null;
    }

    private static FormatStringValidation.ValidationResult validateFormatStringVariable(ExpressionTree formatStringTree, final Symbol formatStringSymbol, final List<? extends ExpressionTree> args, final VisitorState state) {
        TreePath path;
        if (formatStringSymbol.getKind() != ElementKind.LOCAL_VARIABLE) {
            return FormatStringValidation.ValidationResult.create(null, String.format("Variables used as format strings that are not local variables must be compile time consant.\n%s is not a local variable and is not compile time constant.", formatStringTree));
        }
        Symbol owner = formatStringSymbol.owner;
        for (path = TreePath.getPath(state.getPath(), (Tree)formatStringTree); path != null && ASTHelpers.getSymbol((Tree)path.getLeaf()) != owner; path = path.getParentPath()) {
        }
        if (path == null) {
            throw new IllegalStateException(String.format("Could not find the Tree where local variable %s is declared. This should be impossible.", formatStringTree));
        }
        FormatStringValidation.ValidationResult result = path.getLeaf().accept(new TreeScanner<FormatStringValidation.ValidationResult, Void>(){

            @Override
            public FormatStringValidation.ValidationResult visitVariable(VariableTree node, Void unused) {
                if (ASTHelpers.getSymbol((VariableTree)node) == formatStringSymbol) {
                    if (node.getInitializer() == null) {
                        return FormatStringValidation.ValidationResult.create(null, String.format("Variables used as format strings must be initialized when they are declared.\nInvalid declaration: %s", node));
                    }
                    return StrictFormatStringValidation.validateStringFromAssignment(node, node.getInitializer(), args, state);
                }
                return (FormatStringValidation.ValidationResult)super.visitVariable(node, unused);
            }

            @Override
            public FormatStringValidation.ValidationResult reduce(FormatStringValidation.ValidationResult r1, FormatStringValidation.ValidationResult r2) {
                if (r1 == null && r2 == null) {
                    return null;
                }
                return (FormatStringValidation.ValidationResult)MoreObjects.firstNonNull((Object)r1, (Object)r2);
            }
        }, null);
        return result;
    }

    private static FormatStringValidation.ValidationResult validateStringFromAssignment(Tree formatStringAssignment, ExpressionTree formatStringRhs, List<? extends ExpressionTree> args, VisitorState state) {
        String value = (String)ASTHelpers.constValue((Tree)formatStringRhs, String.class);
        if (value == null) {
            return FormatStringValidation.ValidationResult.create(null, String.format("Local format string variables must only be assigned to compile time constant values. Invalid format string assignment: %s", formatStringAssignment));
        }
        return FormatStringValidation.validate((Collection<? extends ExpressionTree>)ImmutableList.builder().add((Object)formatStringRhs).addAll(args).build(), state);
    }

    private static boolean isFormatStringParameter(Symbol formatString, VisitorState state) {
        Type stringType = state.getSymtab().stringType;
        if (!(ASTHelpers.isSameType((Type)formatString.type, (Type)stringType, (VisitorState)state) && formatString.owner instanceof Symbol.MethodSymbol && ASTHelpers.hasAnnotation((Symbol)formatString.owner, FormatMethod.class, (VisitorState)state))) {
            return false;
        }
        if (ASTHelpers.hasAnnotation((Symbol)formatString, FormatString.class, (VisitorState)state)) {
            return true;
        }
        Symbol.MethodSymbol owner = (Symbol.MethodSymbol)formatString.owner;
        boolean formatStringFound = false;
        for (Symbol param : owner.getParameters()) {
            if (param == formatString) {
                formatStringFound = true;
            }
            if (!ASTHelpers.isSameType((Type)param.type, (Type)stringType, (VisitorState)state)) continue;
            if (!formatStringFound) {
                return false;
            }
            if (!ASTHelpers.hasAnnotation((Symbol)param, FormatString.class, (VisitorState)state)) continue;
            return false;
        }
        return true;
    }

    private StrictFormatStringValidation() {
    }
}

