/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMethodMatcher;

public class InliningImplementationMatcher
implements LatentMethodMatcher {
    private final ElementMatcher<? super MethodDescription> ignoredMethods;
    private final ElementMatcher<? super MethodDescription> predefinedMethodSignatures;

    protected InliningImplementationMatcher(ElementMatcher<? super MethodDescription> ignoredMethods, ElementMatcher<? super MethodDescription> predefinedMethodSignatures) {
        this.ignoredMethods = ignoredMethods;
        this.predefinedMethodSignatures = predefinedMethodSignatures;
    }

    protected static LatentMethodMatcher of(ElementMatcher<? super MethodDescription> ignoredMethods, TypeDescription targetType) {
        ElementMatcher.Junction predefinedMethodSignatures = ElementMatchers.none();
        for (MethodDescription methodDescription : targetType.getDeclaredMethods()) {
            ElementMatcher.Junction signature = methodDescription.isConstructor() ? ElementMatchers.isConstructor() : ElementMatchers.named(methodDescription.getName());
            signature = signature.and(ElementMatchers.returns(methodDescription.getReturnType().asErasure()));
            signature = signature.and(ElementMatchers.takesArguments(methodDescription.getParameters().asTypeList().asErasures()));
            predefinedMethodSignatures = predefinedMethodSignatures.or(signature);
        }
        return new InliningImplementationMatcher(ignoredMethods, predefinedMethodSignatures);
    }

    @Override
    public ElementMatcher<? super MethodDescription> resolve(TypeDescription instrumentedType) {
        return ElementMatchers.not(this.ignoredMethods).and(ElementMatchers.isVirtual().and(ElementMatchers.not(ElementMatchers.isFinal())).or(ElementMatchers.isDeclaredBy(instrumentedType))).or(ElementMatchers.isDeclaredBy(instrumentedType).and(ElementMatchers.not(this.predefinedMethodSignatures)));
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.ignoredMethods.equals(((InliningImplementationMatcher)other).ignoredMethods) && this.predefinedMethodSignatures.equals(((InliningImplementationMatcher)other).predefinedMethodSignatures);
    }

    public int hashCode() {
        return 31 * this.ignoredMethods.hashCode() + this.predefinedMethodSignatures.hashCode();
    }

    public String toString() {
        return "InliningImplementationMatcher{ignoredMethods=" + this.ignoredMethods + ", predefinedMethodSignatures=" + this.predefinedMethodSignatures + '}';
    }
}

