/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.propagation;

import com.google.common.base.Preconditions;
import io.opencensus.trace.SpanContext;
import java.text.ParseException;

public abstract class BinaryFormat {
    static final NoopBinaryFormat NOOP_BINARY_FORMAT = new NoopBinaryFormat();

    public abstract byte[] toBinaryValue(SpanContext var1);

    public abstract SpanContext fromBinaryValue(byte[] var1) throws ParseException;

    static BinaryFormat getNoopBinaryFormat() {
        return NOOP_BINARY_FORMAT;
    }

    private static final class NoopBinaryFormat
    extends BinaryFormat {
        @Override
        public byte[] toBinaryValue(SpanContext spanContext) {
            Preconditions.checkNotNull((Object)spanContext, (Object)"spanContext");
            return new byte[0];
        }

        @Override
        public SpanContext fromBinaryValue(byte[] bytes) throws ParseException {
            Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
            return SpanContext.INVALID;
        }

        private NoopBinaryFormat() {
        }
    }
}

