/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.Address;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.impl.PartitionListener;
import com.hazelcast.partition.impl.PartitionReplicaChangeEvent;
import com.hazelcast.partition.impl.PartitionReplicaChangeReason;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

class InternalPartitionImpl
implements InternalPartition {
    @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The contents of this array will never be updated, so it can be safely read using a volatile read. Writing to `addresses` is done under InternalPartitionServiceImpl.lock, so there's no need to guard `addresses` field or to use a CAS.")
    private volatile Address[] addresses = new Address[7];
    private final int partitionId;
    private final PartitionListener partitionListener;
    private final Address thisAddress;
    private volatile boolean isMigrating;

    InternalPartitionImpl(int partitionId, PartitionListener partitionListener, Address thisAddress) {
        this.partitionId = partitionId;
        this.partitionListener = partitionListener;
        this.thisAddress = thisAddress;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isMigrating() {
        return this.isMigrating;
    }

    public void setMigrating(boolean isMigrating) {
        this.isMigrating = isMigrating;
    }

    @Override
    public boolean isLocal() {
        return this.thisAddress.equals(this.getOwnerOrNull());
    }

    @Override
    public Address getOwnerOrNull() {
        return this.addresses[0];
    }

    @Override
    public Address getReplicaAddress(int replicaIndex) {
        return this.addresses[replicaIndex];
    }

    boolean onDeadAddress(Address deadAddress) {
        Address[] currentAddresses = this.addresses;
        for (int i = 0; i < 7; ++i) {
            if (!deadAddress.equals(currentAddresses[i])) continue;
            Address[] newAddresses = Arrays.copyOf(this.addresses, 7);
            int a = i;
            while (a + 1 < 7) {
                newAddresses[a] = newAddresses[a + 1];
                ++a;
            }
            newAddresses[6] = null;
            this.addresses = newAddresses;
            this.callPartitionListener(newAddresses, currentAddresses, PartitionReplicaChangeReason.MEMBER_REMOVED);
            return true;
        }
        return false;
    }

    void setInitialReplicaAddresses(Address[] newAddresses) {
        Address[] oldAddresses = this.addresses;
        for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
            if (oldAddresses[replicaIndex] == null) continue;
            throw new IllegalStateException("Partition is already initialized!");
        }
        this.addresses = newAddresses;
    }

    void setReplicaAddresses(Address[] newAddresses) {
        Address[] oldAddresses = this.addresses;
        this.addresses = newAddresses;
        this.callPartitionListener(newAddresses, oldAddresses, PartitionReplicaChangeReason.ASSIGNMENT);
    }

    private void callPartitionListener(Address[] newAddresses, Address[] oldAddresses, PartitionReplicaChangeReason reason) {
        if (this.partitionListener != null) {
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                Address oldAddress = oldAddresses[replicaIndex];
                Address newAddress = newAddresses[replicaIndex];
                this.callPartitionListener(replicaIndex, oldAddress, newAddress, reason);
            }
        }
    }

    private void callPartitionListener(int replicaIndex, Address oldAddress, Address newAddress, PartitionReplicaChangeReason reason) {
        boolean changed;
        if (oldAddress == null) {
            changed = newAddress != null;
        } else {
            boolean bl = changed = !oldAddress.equals(newAddress);
        }
        if (changed) {
            PartitionReplicaChangeEvent event = new PartitionReplicaChangeEvent(this.partitionId, replicaIndex, oldAddress, newAddress, reason);
            this.partitionListener.replicaChanged(event);
        }
    }

    @Override
    public boolean isOwnerOrBackup(Address address) {
        for (int i = 0; i < 7; ++i) {
            if (!address.equals(this.getReplicaAddress(i))) continue;
            return true;
        }
        return false;
    }

    int getReplicaIndex(Address address) {
        for (int i = 0; i < 7; ++i) {
            if (!address.equals(this.getReplicaAddress(i))) continue;
            return i;
        }
        return -1;
    }

    void reset() {
        this.addresses = new Address[7];
        this.setMigrating(false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Partition [").append(this.partitionId).append("]{\n");
        for (int i = 0; i < 7; ++i) {
            Address address = this.addresses[i];
            if (address == null) continue;
            sb.append('\t');
            sb.append(i).append(":").append(address);
            sb.append("\n");
        }
        sb.append("}");
        return sb.toString();
    }
}

