/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bytecode.BytecodeBinder;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JimageClassBinder {
    private final Multimap<String, String> packageMap;
    private final Path modulesRoot;
    private final Set<String> loadedPackages = new HashSet<String>();
    private final Table<String, String, ClassSymbol> packageClassesBySimpleName = HashBasedTable.create();
    private final Map<String, ModuleInfo> moduleMap = new HashMap<String, ModuleInfo>();
    private final Map<ClassSymbol, BytecodeBoundClass> env = new HashMap<ClassSymbol, BytecodeBoundClass>();

    static JimageClassBinder create(FileSystem fileSystem) throws IOException {
        Path modules = fileSystem.getPath("/modules", new String[0]);
        Path packages = fileSystem.getPath("/packages", new String[0]);
        ImmutableMultimap.Builder packageMap = ImmutableMultimap.builder();
        try (DirectoryStream<Path> ps = Files.newDirectoryStream(packages);){
            for (Path p : ps) {
                String packageName = packages.relativize(p).toString().replace('.', '/');
                DirectoryStream<Path> ms = Files.newDirectoryStream(p);
                Throwable throwable = null;
                try {
                    for (Path m : ms) {
                        packageMap.put((Object)packageName, (Object)p.relativize(m).toString());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ms == null) continue;
                    if (throwable != null) {
                        try {
                            ms.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ms.close();
                }
            }
        }
        return new JimageClassBinder((ImmutableMultimap<String, String>)packageMap.build(), modules);
    }

    public static ClassPath bindDefault() throws IOException {
        JimageClassBinder jimageClassBinder = JimageClassBinder.create(FileSystems.getFileSystem(URI.create("jrt:/")));
        jimageClassBinder.getClass();
        return jimageClassBinder.new JimageClassPath();
    }

    public static ClassPath bind(String javaHome) throws IOException {
        if (javaHome.equals(System.getProperty("java.home"))) {
            return JimageClassBinder.bindDefault();
        }
        FileSystem fileSystem = FileSystems.newFileSystem(URI.create("jrt:/"), ImmutableMap.of((Object)"java.home", (Object)javaHome));
        JimageClassBinder jimageClassBinder = JimageClassBinder.create(fileSystem);
        jimageClassBinder.getClass();
        return jimageClassBinder.new JimageClassPath();
    }

    public JimageClassBinder(ImmutableMultimap<String, String> packageMap, Path modules) {
        this.packageMap = packageMap;
        this.modulesRoot = modules;
    }

    Path modulePath(String moduleName) {
        Path path = this.modulesRoot.resolve(moduleName);
        return Files.exists(path, new LinkOption[0]) ? path : null;
    }

    ModuleInfo module(String moduleName) {
        ModuleInfo result = this.moduleMap.get(moduleName);
        if (result == null) {
            Path path = this.modulePath(moduleName);
            if (path == null) {
                return null;
            }
            try {
                path = path.resolve("module-info.class");
                result = BytecodeBinder.bindModuleInfo(path.toString(), JimageClassBinder.toByteArrayOrDie(path));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.moduleMap.put(moduleName, result);
        }
        return result;
    }

    boolean initPackage(String packageName) {
        Collection moduleNames = this.packageMap.get((Object)packageName);
        if (moduleNames.isEmpty()) {
            return false;
        }
        if (!this.loadedPackages.add(packageName)) {
            return true;
        }
        Env<ClassSymbol, BytecodeBoundClass> env = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)JimageClassBinder.this.env.get(sym);
            }
        };
        for (String moduleName : moduleNames) {
            if (moduleName == null) continue;
            Path modulePath = this.modulePath(moduleName);
            Path modulePackagePath = modulePath.resolve(packageName);
            try {
                DirectoryStream<Path> ds = Files.newDirectoryStream(modulePackagePath);
                Throwable throwable = null;
                try {
                    for (Path path : ds) {
                        if (!Files.isRegularFile(path, new LinkOption[0]) || path.getFileName().toString().equals("module-info.class")) continue;
                        String binaryName = modulePath.relativize(path).toString();
                        binaryName = binaryName.substring(0, binaryName.length() - ".class".length());
                        ClassSymbol sym = new ClassSymbol(binaryName);
                        this.packageClassesBySimpleName.put((Object)packageName, (Object)JimageClassBinder.simpleName(sym), (Object)sym);
                        this.env.put(sym, new BytecodeBoundClass(sym, JimageClassBinder.toByteArrayOrDie(path), env, path.toString()));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return true;
    }

    private static Supplier<byte[]> toByteArrayOrDie(final Path path) {
        return Suppliers.memoize((Supplier)new Supplier<byte[]>(){

            public byte[] get() {
                try {
                    return Files.readAllBytes(path);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private static String simpleName(ClassSymbol sym) {
        int idx = sym.binaryName().lastIndexOf(47);
        return idx != -1 ? sym.binaryName().substring(idx + 1) : sym.binaryName();
    }

    private static String packageName(ClassSymbol sym) {
        int idx = sym.binaryName().lastIndexOf(47);
        return idx != -1 ? sym.binaryName().substring(0, idx) : "";
    }

    private class JimageClassPath
    implements ClassPath {
        final TopLevelIndex index;

        private JimageClassPath() {
            this.index = new JimageTopLevelIndex();
        }

        @Override
        public Env<ClassSymbol, BytecodeBoundClass> env() {
            return new Env<ClassSymbol, BytecodeBoundClass>(){

                @Override
                public BytecodeBoundClass get(ClassSymbol sym) {
                    return JimageClassBinder.this.initPackage(JimageClassBinder.packageName(sym)) ? (BytecodeBoundClass)JimageClassBinder.this.env.get(sym) : null;
                }
            };
        }

        @Override
        public Env<ModuleSymbol, ModuleInfo> moduleEnv() {
            return new Env<ModuleSymbol, ModuleInfo>(){

                @Override
                public ModuleInfo get(ModuleSymbol module) {
                    return JimageClassBinder.this.module(module.name());
                }
            };
        }

        @Override
        public TopLevelIndex index() {
            return this.index;
        }
    }

    private class JimageTopLevelIndex
    implements TopLevelIndex {
        final Scope topLevelScope = new Scope(){

            @Override
            public @Nullable LookupResult lookup(LookupKey lookupKey) {
                Scope scope = null;
                ImmutableList<String> names = lookupKey.simpleNames();
                int idx = -1;
                for (int i = 1; i < names.size(); ++i) {
                    Scope cand = JimageTopLevelIndex.this.lookupPackage((ImmutableList<String>)names.subList(0, i));
                    if (cand == null) continue;
                    scope = cand;
                    idx = i;
                }
                return scope != null ? scope.lookup(new LookupKey((Iterable<String>)names.subList(idx, names.size()))) : null;
            }
        };

        private JimageTopLevelIndex() {
        }

        @Override
        public Scope scope() {
            return this.topLevelScope;
        }

        @Override
        public Scope lookupPackage(ImmutableList<String> name) {
            final String packageName = Joiner.on((char)'/').join(name);
            if (!JimageClassBinder.this.initPackage(packageName)) {
                return null;
            }
            return new Scope(){

                @Override
                public @Nullable LookupResult lookup(LookupKey lookupKey) {
                    ClassSymbol sym = (ClassSymbol)JimageClassBinder.this.packageClassesBySimpleName.get((Object)packageName, (Object)lookupKey.first());
                    return sym != null ? new LookupResult(sym, lookupKey) : null;
                }
            };
        }
    }
}

