/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.AllocationInstrumenter;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.ConstructorCallback;
import com.google.monitoring.runtime.instrumentation.VerifyingClassAdapter;
import com.google.monitoring.runtime.instrumentation.asm.ClassReader;
import com.google.monitoring.runtime.instrumentation.asm.ClassVisitor;
import com.google.monitoring.runtime.instrumentation.asm.ClassWriter;
import com.google.monitoring.runtime.instrumentation.asm.MethodVisitor;
import com.google.monitoring.runtime.instrumentation.asm.commons.LocalVariablesSorter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConstructorInstrumenter
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(ConstructorInstrumenter.class.getName());
    private static ConcurrentHashMap<Class<?>, List<ConstructorCallback<?>>> samplerMap = new ConcurrentHashMap();
    private static final Object samplerPutAtomicityLock = new Object();
    static boolean subclassesAlso;

    ConstructorInstrumenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void instrumentClass(Class<?> c, ConstructorCallback<?> sampler) throws UnmodifiableClassException {
        Object object = samplerPutAtomicityLock;
        synchronized (object) {
            List<ConstructorCallback<?>> list = samplerMap.get(c);
            if (list == null) {
                CopyOnWriteArrayList samplerList = new CopyOnWriteArrayList();
                samplerList.add(sampler);
                samplerMap.put(c, samplerList);
                Instrumentation inst = AllocationRecorder.getInstrumentation();
                Class[] cs = new Class[]{c};
                inst.retransformClasses(c);
            } else {
                list.add(sampler);
            }
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (classBeingRedefined == null || !samplerMap.containsKey(classBeingRedefined)) {
            return null;
        }
        if (!AllocationInstrumenter.canRewriteClass(className, loader)) {
            throw new RuntimeException(new UnmodifiableClassException("cannot instrument " + className));
        }
        return ConstructorInstrumenter.instrument(classfileBuffer, classBeingRedefined);
    }

    public static byte[] instrument(byte[] originalBytes, Class<?> classBeingRedefined) {
        try {
            ClassReader cr = new ClassReader(originalBytes);
            ClassWriter cw = new ClassWriter(cr, 1);
            VerifyingClassAdapter vcw = new VerifyingClassAdapter(cw, originalBytes, cr.getClassName());
            ConstructorClassAdapter adapter = new ConstructorClassAdapter(vcw, classBeingRedefined);
            cr.accept(adapter, 4);
            return vcw.toByteArray();
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to instrument class.", e);
            throw e;
        }
        catch (Error e) {
            logger.log(Level.WARNING, "Failed to instrument class.", e);
            throw e;
        }
    }

    public static void invokeSamplers(Object o) {
        for (Class<?> currentClass = o.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            List<ConstructorCallback<?>> samplers = samplerMap.get(currentClass);
            if (samplers != null) {
                for (ConstructorCallback<?> sampler : samplers) {
                    sampler.sample(o);
                }
                return;
            }
            if (subclassesAlso) continue;
            return;
        }
    }

    static class ConstructorClassAdapter
    extends ClassVisitor {
        Class<?> cl;

        public ConstructorClassAdapter(ClassVisitor cv, Class<?> cl) {
            super(327680, cv);
            this.cl = cl;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (mv != null && "<init>".equals(name)) {
                LocalVariablesSorter lvs;
                ConstructorMethodAdapter aimv = new ConstructorMethodAdapter(mv, this.cl);
                aimv.lvs = lvs = new LocalVariablesSorter(access, desc, aimv);
                mv = lvs;
            }
            return mv;
        }
    }

    static class ConstructorMethodAdapter
    extends MethodVisitor {
        public LocalVariablesSorter lvs = null;
        Class<?> cl;

        ConstructorMethodAdapter(MethodVisitor mv, Class<?> cl) {
            super(327680, mv);
            this.cl = cl;
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode == 176 || opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175) {
                throw new RuntimeException(new UnmodifiableClassException("Constructors are supposed to return void"));
            }
            if (opcode == 177) {
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(184, "com/google/monitoring/runtime/instrumentation/ConstructorInstrumenter", "invokeSamplers", "(Ljava/lang/Object;)V", false);
            }
            super.visitInsn(opcode);
        }
    }
}

