package com.google.devtools.build.v1;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * A service for publishing BuildEvents. BuildEvents are generated by Build
 * Systems to record actions taken during a Build. Events occur in streams,
 * are identified by a StreamId, and ordered by sequence number in a stream.
 * A Build may contain several streams of BuildEvents, depending on the systems
 * that are involved in the Build. Some BuildEvents are used to declare the
 * beginning and end of major portions of a Build; these are called
 * LifecycleEvents, and are used (for example) to indicate the beginning or end
 * of a Build, and the beginning or end of an Invocation attempt (there can be
 * more than 1 Invocation in a Build if, for example, a failure occurs somewhere
 * and it needs to be retried).
 * Other, build-tool events represent actions taken by the Build tool, such as
 * target objects produced via compilation, tests run, et cetera. There could be
 * more than one build tool stream for an invocation attempt of a build.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: google/devtools/build/v1/publish_build_event.proto")
public final class PublishBuildEventGrpc {

  private PublishBuildEventGrpc() {}

  public static final String SERVICE_NAME = "google.devtools.build.v1.PublishBuildEvent";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getPublishLifecycleEventMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishLifecycleEventRequest,
      com.google.protobuf.Empty> METHOD_PUBLISH_LIFECYCLE_EVENT = getPublishLifecycleEventMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishLifecycleEventRequest,
      com.google.protobuf.Empty> getPublishLifecycleEventMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishLifecycleEventRequest,
      com.google.protobuf.Empty> getPublishLifecycleEventMethod() {
    return getPublishLifecycleEventMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishLifecycleEventRequest,
      com.google.protobuf.Empty> getPublishLifecycleEventMethodHelper() {
    io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishLifecycleEventRequest, com.google.protobuf.Empty> getPublishLifecycleEventMethod;
    if ((getPublishLifecycleEventMethod = PublishBuildEventGrpc.getPublishLifecycleEventMethod) == null) {
      synchronized (PublishBuildEventGrpc.class) {
        if ((getPublishLifecycleEventMethod = PublishBuildEventGrpc.getPublishLifecycleEventMethod) == null) {
          PublishBuildEventGrpc.getPublishLifecycleEventMethod = getPublishLifecycleEventMethod = 
              io.grpc.MethodDescriptor.<com.google.devtools.build.v1.PublishLifecycleEventRequest, com.google.protobuf.Empty>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "google.devtools.build.v1.PublishBuildEvent", "PublishLifecycleEvent"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.build.v1.PublishLifecycleEventRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.protobuf.Empty.getDefaultInstance()))
                  .setSchemaDescriptor(new PublishBuildEventMethodDescriptorSupplier("PublishLifecycleEvent"))
                  .build();
          }
        }
     }
     return getPublishLifecycleEventMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getPublishBuildToolEventStreamMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest,
      com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> METHOD_PUBLISH_BUILD_TOOL_EVENT_STREAM = getPublishBuildToolEventStreamMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest,
      com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> getPublishBuildToolEventStreamMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest,
      com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> getPublishBuildToolEventStreamMethod() {
    return getPublishBuildToolEventStreamMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest,
      com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> getPublishBuildToolEventStreamMethodHelper() {
    io.grpc.MethodDescriptor<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest, com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> getPublishBuildToolEventStreamMethod;
    if ((getPublishBuildToolEventStreamMethod = PublishBuildEventGrpc.getPublishBuildToolEventStreamMethod) == null) {
      synchronized (PublishBuildEventGrpc.class) {
        if ((getPublishBuildToolEventStreamMethod = PublishBuildEventGrpc.getPublishBuildToolEventStreamMethod) == null) {
          PublishBuildEventGrpc.getPublishBuildToolEventStreamMethod = getPublishBuildToolEventStreamMethod = 
              io.grpc.MethodDescriptor.<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest, com.google.devtools.build.v1.PublishBuildToolEventStreamResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "google.devtools.build.v1.PublishBuildEvent", "PublishBuildToolEventStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.build.v1.PublishBuildToolEventStreamRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.build.v1.PublishBuildToolEventStreamResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new PublishBuildEventMethodDescriptorSupplier("PublishBuildToolEventStream"))
                  .build();
          }
        }
     }
     return getPublishBuildToolEventStreamMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static PublishBuildEventStub newStub(io.grpc.Channel channel) {
    return new PublishBuildEventStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static PublishBuildEventBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new PublishBuildEventBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static PublishBuildEventFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new PublishBuildEventFutureStub(channel);
  }

  /**
   * <pre>
   * A service for publishing BuildEvents. BuildEvents are generated by Build
   * Systems to record actions taken during a Build. Events occur in streams,
   * are identified by a StreamId, and ordered by sequence number in a stream.
   * A Build may contain several streams of BuildEvents, depending on the systems
   * that are involved in the Build. Some BuildEvents are used to declare the
   * beginning and end of major portions of a Build; these are called
   * LifecycleEvents, and are used (for example) to indicate the beginning or end
   * of a Build, and the beginning or end of an Invocation attempt (there can be
   * more than 1 Invocation in a Build if, for example, a failure occurs somewhere
   * and it needs to be retried).
   * Other, build-tool events represent actions taken by the Build tool, such as
   * target objects produced via compilation, tests run, et cetera. There could be
   * more than one build tool stream for an invocation attempt of a build.
   * </pre>
   */
  public static abstract class PublishBuildEventImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Publish a build event stating the new state of a build (typically from the
     * build queue). If the event is a BuildEnqueued event, also register the new
     * build request ID and its build type to BES.
     * The backend will persist the event and deliver it to registered frontend
     * jobs immediately without batching.
     * The commit status of the request is reported by the RPC's util_status()
     * function. The error code is the canoncial error code defined in
     * //util/task/codes.proto.
     * </pre>
     */
    public void publishLifecycleEvent(com.google.devtools.build.v1.PublishLifecycleEventRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnimplementedUnaryCall(getPublishLifecycleEventMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * Publish build tool events belonging to the same stream to a backend job
     * using bidirectional streaming.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest> publishBuildToolEventStream(
        io.grpc.stub.StreamObserver<com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> responseObserver) {
      return asyncUnimplementedStreamingCall(getPublishBuildToolEventStreamMethodHelper(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPublishLifecycleEventMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.google.devtools.build.v1.PublishLifecycleEventRequest,
                com.google.protobuf.Empty>(
                  this, METHODID_PUBLISH_LIFECYCLE_EVENT)))
          .addMethod(
            getPublishBuildToolEventStreamMethodHelper(),
            asyncBidiStreamingCall(
              new MethodHandlers<
                com.google.devtools.build.v1.PublishBuildToolEventStreamRequest,
                com.google.devtools.build.v1.PublishBuildToolEventStreamResponse>(
                  this, METHODID_PUBLISH_BUILD_TOOL_EVENT_STREAM)))
          .build();
    }
  }

  /**
   * <pre>
   * A service for publishing BuildEvents. BuildEvents are generated by Build
   * Systems to record actions taken during a Build. Events occur in streams,
   * are identified by a StreamId, and ordered by sequence number in a stream.
   * A Build may contain several streams of BuildEvents, depending on the systems
   * that are involved in the Build. Some BuildEvents are used to declare the
   * beginning and end of major portions of a Build; these are called
   * LifecycleEvents, and are used (for example) to indicate the beginning or end
   * of a Build, and the beginning or end of an Invocation attempt (there can be
   * more than 1 Invocation in a Build if, for example, a failure occurs somewhere
   * and it needs to be retried).
   * Other, build-tool events represent actions taken by the Build tool, such as
   * target objects produced via compilation, tests run, et cetera. There could be
   * more than one build tool stream for an invocation attempt of a build.
   * </pre>
   */
  public static final class PublishBuildEventStub extends io.grpc.stub.AbstractStub<PublishBuildEventStub> {
    private PublishBuildEventStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PublishBuildEventStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PublishBuildEventStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PublishBuildEventStub(channel, callOptions);
    }

    /**
     * <pre>
     * Publish a build event stating the new state of a build (typically from the
     * build queue). If the event is a BuildEnqueued event, also register the new
     * build request ID and its build type to BES.
     * The backend will persist the event and deliver it to registered frontend
     * jobs immediately without batching.
     * The commit status of the request is reported by the RPC's util_status()
     * function. The error code is the canoncial error code defined in
     * //util/task/codes.proto.
     * </pre>
     */
    public void publishLifecycleEvent(com.google.devtools.build.v1.PublishLifecycleEventRequest request,
        io.grpc.stub.StreamObserver<com.google.protobuf.Empty> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPublishLifecycleEventMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Publish build tool events belonging to the same stream to a backend job
     * using bidirectional streaming.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<com.google.devtools.build.v1.PublishBuildToolEventStreamRequest> publishBuildToolEventStream(
        io.grpc.stub.StreamObserver<com.google.devtools.build.v1.PublishBuildToolEventStreamResponse> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(getPublishBuildToolEventStreamMethodHelper(), getCallOptions()), responseObserver);
    }
  }

  /**
   * <pre>
   * A service for publishing BuildEvents. BuildEvents are generated by Build
   * Systems to record actions taken during a Build. Events occur in streams,
   * are identified by a StreamId, and ordered by sequence number in a stream.
   * A Build may contain several streams of BuildEvents, depending on the systems
   * that are involved in the Build. Some BuildEvents are used to declare the
   * beginning and end of major portions of a Build; these are called
   * LifecycleEvents, and are used (for example) to indicate the beginning or end
   * of a Build, and the beginning or end of an Invocation attempt (there can be
   * more than 1 Invocation in a Build if, for example, a failure occurs somewhere
   * and it needs to be retried).
   * Other, build-tool events represent actions taken by the Build tool, such as
   * target objects produced via compilation, tests run, et cetera. There could be
   * more than one build tool stream for an invocation attempt of a build.
   * </pre>
   */
  public static final class PublishBuildEventBlockingStub extends io.grpc.stub.AbstractStub<PublishBuildEventBlockingStub> {
    private PublishBuildEventBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PublishBuildEventBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PublishBuildEventBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PublishBuildEventBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Publish a build event stating the new state of a build (typically from the
     * build queue). If the event is a BuildEnqueued event, also register the new
     * build request ID and its build type to BES.
     * The backend will persist the event and deliver it to registered frontend
     * jobs immediately without batching.
     * The commit status of the request is reported by the RPC's util_status()
     * function. The error code is the canoncial error code defined in
     * //util/task/codes.proto.
     * </pre>
     */
    public com.google.protobuf.Empty publishLifecycleEvent(com.google.devtools.build.v1.PublishLifecycleEventRequest request) {
      return blockingUnaryCall(
          getChannel(), getPublishLifecycleEventMethodHelper(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * A service for publishing BuildEvents. BuildEvents are generated by Build
   * Systems to record actions taken during a Build. Events occur in streams,
   * are identified by a StreamId, and ordered by sequence number in a stream.
   * A Build may contain several streams of BuildEvents, depending on the systems
   * that are involved in the Build. Some BuildEvents are used to declare the
   * beginning and end of major portions of a Build; these are called
   * LifecycleEvents, and are used (for example) to indicate the beginning or end
   * of a Build, and the beginning or end of an Invocation attempt (there can be
   * more than 1 Invocation in a Build if, for example, a failure occurs somewhere
   * and it needs to be retried).
   * Other, build-tool events represent actions taken by the Build tool, such as
   * target objects produced via compilation, tests run, et cetera. There could be
   * more than one build tool stream for an invocation attempt of a build.
   * </pre>
   */
  public static final class PublishBuildEventFutureStub extends io.grpc.stub.AbstractStub<PublishBuildEventFutureStub> {
    private PublishBuildEventFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private PublishBuildEventFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected PublishBuildEventFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new PublishBuildEventFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Publish a build event stating the new state of a build (typically from the
     * build queue). If the event is a BuildEnqueued event, also register the new
     * build request ID and its build type to BES.
     * The backend will persist the event and deliver it to registered frontend
     * jobs immediately without batching.
     * The commit status of the request is reported by the RPC's util_status()
     * function. The error code is the canoncial error code defined in
     * //util/task/codes.proto.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.protobuf.Empty> publishLifecycleEvent(
        com.google.devtools.build.v1.PublishLifecycleEventRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getPublishLifecycleEventMethodHelper(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PUBLISH_LIFECYCLE_EVENT = 0;
  private static final int METHODID_PUBLISH_BUILD_TOOL_EVENT_STREAM = 1;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final PublishBuildEventImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(PublishBuildEventImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PUBLISH_LIFECYCLE_EVENT:
          serviceImpl.publishLifecycleEvent((com.google.devtools.build.v1.PublishLifecycleEventRequest) request,
              (io.grpc.stub.StreamObserver<com.google.protobuf.Empty>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PUBLISH_BUILD_TOOL_EVENT_STREAM:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.publishBuildToolEventStream(
              (io.grpc.stub.StreamObserver<com.google.devtools.build.v1.PublishBuildToolEventStreamResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class PublishBuildEventBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    PublishBuildEventBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.google.devtools.build.v1.BackendProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("PublishBuildEvent");
    }
  }

  private static final class PublishBuildEventFileDescriptorSupplier
      extends PublishBuildEventBaseDescriptorSupplier {
    PublishBuildEventFileDescriptorSupplier() {}
  }

  private static final class PublishBuildEventMethodDescriptorSupplier
      extends PublishBuildEventBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    PublishBuildEventMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (PublishBuildEventGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new PublishBuildEventFileDescriptorSupplier())
              .addMethod(getPublishLifecycleEventMethodHelper())
              .addMethod(getPublishBuildToolEventStreamMethodHelper())
              .build();
        }
      }
    }
    return result;
  }
}
