/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bound.AnnotationValue;
import com.google.turbine.binder.bound.ClassValue;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ClassReader;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.bytecode.sig.SigParser;
import com.google.turbine.model.Const;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class BytecodeBinder {
    static Type.ClassTy bindClassTy(Sig.ClassTySig sig, Function<String, TyVarSymbol> scope) {
        StringBuilder sb = new StringBuilder(sig.pkg());
        boolean first = true;
        ArrayList<Type.ClassTy.SimpleClassTy> classes = new ArrayList<Type.ClassTy.SimpleClassTy>();
        for (Sig.SimpleClassTySig s : sig.classes()) {
            sb.append(first ? (char)'/' : '$');
            sb.append(s.simpleName());
            ClassSymbol sym = new ClassSymbol(sb.toString());
            ImmutableList.Builder tyArgs = ImmutableList.builder();
            for (Sig.TySig arg : s.tyArgs()) {
                tyArgs.add((Object)BytecodeBinder.bindTy(arg, scope));
            }
            classes.add(new Type.ClassTy.SimpleClassTy(sym, (ImmutableList<Type>)tyArgs.build(), (ImmutableList<AnnoInfo>)ImmutableList.of()));
            first = false;
        }
        return new Type.ClassTy(classes);
    }

    private static Type wildTy(Sig.WildTySig sig, Function<String, TyVarSymbol> scope) {
        switch (sig.boundKind()) {
            case NONE: {
                return new Type.WildUnboundedTy((ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case LOWER: {
                return new Type.WildLowerBoundedTy(BytecodeBinder.bindTy(((Sig.LowerBoundTySig)sig).bound(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case UPPER: {
                return new Type.WildUpperBoundedTy(BytecodeBinder.bindTy(((Sig.UpperBoundTySig)sig).bound(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        }
        throw new AssertionError((Object)sig.boundKind());
    }

    static Type bindTy(Sig.TySig sig, Function<String, TyVarSymbol> scope) {
        switch (sig.kind()) {
            case BASE_TY_SIG: {
                return new Type.PrimTy(((Sig.BaseTySig)sig).type(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case CLASS_TY_SIG: {
                return BytecodeBinder.bindClassTy((Sig.ClassTySig)sig, scope);
            }
            case TY_VAR_SIG: {
                return new Type.TyVar(scope.apply(((Sig.TyVarSig)sig).name()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case ARRAY_TY_SIG: {
                return BytecodeBinder.bindArrayTy((Sig.ArrayTySig)sig, scope);
            }
            case WILD_TY_SIG: {
                return BytecodeBinder.wildTy((Sig.WildTySig)sig, scope);
            }
            case VOID_TY_SIG: {
                return Type.VOID;
            }
        }
        throw new AssertionError((Object)sig.kind());
    }

    private static Type bindArrayTy(Sig.ArrayTySig arrayTySig, Function<String, TyVarSymbol> scope) {
        return new Type.ArrayTy(BytecodeBinder.bindTy(arrayTySig.elementType(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    public static Const bindValue(Type type, ClassFile.AnnotationInfo.ElementValue value) {
        switch (value.kind()) {
            case ENUM: {
                return BytecodeBinder.bindEnumValue((ClassFile.AnnotationInfo.ElementValue.EnumConstValue)value);
            }
            case CONST: {
                return BytecodeBinder.bindConstValue(type, ((ClassFile.AnnotationInfo.ElementValue.ConstValue)value).value());
            }
            case ARRAY: {
                return BytecodeBinder.bindArrayValue(type, (ClassFile.AnnotationInfo.ElementValue.ArrayValue)value);
            }
            case CLASS: {
                return new ClassValue(BytecodeBinder.bindTy(new SigParser(((ClassFile.AnnotationInfo.ElementValue.ConstClassValue)value).className()).parseType(), x -> {
                    throw new IllegalStateException((String)x);
                }));
            }
            case ANNOTATION: {
                return BytecodeBinder.bindAnnotationValue(type, ((ClassFile.AnnotationInfo.ElementValue.AnnotationValue)value).annotation());
            }
        }
        throw new AssertionError((Object)value.kind());
    }

    static AnnotationValue bindAnnotationValue(Type type, ClassFile.AnnotationInfo value) {
        ClassSymbol sym = BytecodeBinder.asClassSymbol(value.typeName());
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (Map.Entry<String, ClassFile.AnnotationInfo.ElementValue> e : value.elementValuePairs().entrySet()) {
            values.put((Object)e.getKey(), (Object)BytecodeBinder.bindValue(type, e.getValue()));
        }
        return new AnnotationValue(sym, (ImmutableMap<String, Const>)values.build());
    }

    static ImmutableList<AnnoInfo> bindAnnotations(List<ClassFile.AnnotationInfo> input) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ClassFile.AnnotationInfo annotation : input) {
            AnnotationValue anno = BytecodeBinder.bindAnnotationValue(Type.VOID, annotation);
            result.add((Object)new AnnoInfo(null, anno.sym(), null, anno.values()));
        }
        return result.build();
    }

    private static ClassSymbol asClassSymbol(String s) {
        return new ClassSymbol(s.substring(1, s.length() - 1));
    }

    private static Const bindArrayValue(Type type, ClassFile.AnnotationInfo.ElementValue.ArrayValue value) {
        ImmutableList.Builder elements = ImmutableList.builder();
        for (ClassFile.AnnotationInfo.ElementValue element : value.elements()) {
            elements.add((Object)BytecodeBinder.bindValue(type, element));
        }
        return new Const.ArrayInitValue((ImmutableList<Const>)elements.build());
    }

    public static Const.Value bindConstValue(Type type, Const.Value value) {
        if (type.tyKind() != Type.TyKind.PRIM_TY) {
            return value;
        }
        switch (((Type.PrimTy)type).primkind()) {
            case CHAR: {
                return new Const.CharValue(value.asChar().value());
            }
            case SHORT: {
                return new Const.ShortValue(value.asShort().value());
            }
            case INT: {
                return new Const.IntValue(value.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(value.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(value.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(value.asDouble().value());
            }
            case BOOLEAN: {
                return new Const.BooleanValue(value.asInteger().value() != 0);
            }
            case BYTE: {
                return new Const.ByteValue(value.asByte().value());
            }
            case STRING: 
            case NULL: {
                return value;
            }
        }
        throw new AssertionError(type);
    }

    private static Const bindEnumValue(ClassFile.AnnotationInfo.ElementValue.EnumConstValue value) {
        return new EnumConstantValue(new FieldSymbol(BytecodeBinder.asClassSymbol(value.typeName()), value.constName()));
    }

    public static ModuleInfo bindModuleInfo(String path, Supplier<byte[]> bytes) {
        ClassFile classFile = ClassReader.read(path, bytes.get());
        ClassFile.ModuleInfo module = classFile.module();
        return new ModuleInfo(module.name(), module.version(), module.flags(), (ImmutableList<AnnoInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.RequireInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ExportInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.OpenInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.UseInfo>)ImmutableList.of(), (ImmutableList<ModuleInfo.ProvideInfo>)ImmutableList.of());
    }
}

