/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.turbine.bytecode.ByteReader;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPoolReader;
import com.google.turbine.model.Const;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassReader {
    private final @Nullable String path;
    private final ByteReader reader;

    @Deprecated
    public static ClassFile read(byte[] bytes) {
        return ClassReader.read(null, bytes);
    }

    public static ClassFile read(@Nullable String path, byte[] bytes) {
        return new ClassReader(path, bytes).read();
    }

    private ClassReader(@Nullable String path, byte[] bytes) {
        this.path = path;
        this.reader = new ByteReader(bytes, 0);
    }

    @CheckReturnValue
    Error error(String format, Object ... args) {
        StringBuilder sb = new StringBuilder();
        if (this.path != null) {
            sb.append(this.path).append(": ");
        }
        sb.append(String.format(format, args));
        return new AssertionError((Object)sb.toString());
    }

    private ClassFile read() {
        int magic = this.reader.u4();
        if (magic != -889275714) {
            throw this.error("bad magic: 0x%x", this.path, magic);
        }
        int minorVersion = this.reader.u2();
        int majorVersion = this.reader.u2();
        if (majorVersion < 45) {
            throw this.error("bad version: %d.%d", majorVersion, minorVersion);
        }
        ConstantPoolReader constantPool = ConstantPoolReader.readConstantPool(this.reader);
        int accessFlags = this.reader.u2();
        String thisClass = constantPool.classInfo(this.reader.u2());
        int superClassIndex = this.reader.u2();
        String superClass = superClassIndex != 0 ? constantPool.classInfo(superClassIndex) : null;
        int interfacesCount = this.reader.u2();
        ArrayList<String> interfaces = new ArrayList<String>();
        for (int i = 0; i < interfacesCount; ++i) {
            interfaces.add(constantPool.classInfo(this.reader.u2()));
        }
        List<ClassFile.FieldInfo> fieldinfos = this.readFields(constantPool);
        List<ClassFile.MethodInfo> methodinfos = this.readMethods(constantPool);
        String signature = null;
        List<ClassFile.InnerClass> innerclasses = Collections.emptyList();
        ImmutableList.Builder annotations = ImmutableList.builder();
        ClassFile.ModuleInfo module = null;
        int attributesCount = this.reader.u2();
        block14: for (int j = 0; j < attributesCount; ++j) {
            String name;
            int attributeNameIndex = this.reader.u2();
            switch (name = constantPool.utf8(attributeNameIndex)) {
                case "RuntimeInvisibleAnnotations": 
                case "RuntimeVisibleAnnotations": {
                    this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool);
                    continue block14;
                }
                case "Signature": {
                    signature = this.readSignature(constantPool);
                    continue block14;
                }
                case "InnerClasses": {
                    innerclasses = this.readInnerClasses(constantPool, thisClass);
                    continue block14;
                }
                case "Module": {
                    module = this.readModule(constantPool);
                    continue block14;
                }
                default: {
                    this.reader.skip(this.reader.u4());
                }
            }
        }
        return new ClassFile(accessFlags, thisClass, signature, superClass, interfaces, methodinfos, fieldinfos, (List<ClassFile.AnnotationInfo>)annotations.build(), innerclasses, (ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.of(), module);
    }

    private String readSignature(ConstantPoolReader constantPool) {
        this.reader.u4();
        String signature = constantPool.utf8(this.reader.u2());
        return signature;
    }

    private List<ClassFile.InnerClass> readInnerClasses(ConstantPoolReader constantPool, String thisClass) {
        this.reader.u4();
        int numberOfClasses = this.reader.u2();
        ArrayList<ClassFile.InnerClass> innerclasses = new ArrayList<ClassFile.InnerClass>();
        for (int i = 0; i < numberOfClasses; ++i) {
            int innerClassInfoIndex = this.reader.u2();
            String innerClass = constantPool.classInfo(innerClassInfoIndex);
            int outerClassInfoIndex = this.reader.u2();
            String outerClass = outerClassInfoIndex != 0 ? constantPool.classInfo(outerClassInfoIndex) : null;
            int innerNameIndex = this.reader.u2();
            String innerName = innerNameIndex != 0 ? constantPool.utf8(innerNameIndex) : null;
            int innerClassAccessFlags = this.reader.u2();
            if (innerName == null || !thisClass.equals(innerClass) && !thisClass.equals(outerClass)) continue;
            innerclasses.add(new ClassFile.InnerClass(innerClass, outerClass, innerName, innerClassAccessFlags));
        }
        return innerclasses;
    }

    private void readAnnotations(ImmutableList.Builder<ClassFile.AnnotationInfo> annotations, ConstantPoolReader constantPool) {
        this.reader.u4();
        int numAnnotations = this.reader.u2();
        for (int n = 0; n < numAnnotations; ++n) {
            annotations.add((Object)this.readAnnotation(constantPool));
        }
    }

    public void readParameterAnnotations(List<ImmutableList.Builder<ClassFile.AnnotationInfo>> annotations, ConstantPoolReader constantPool) {
        this.reader.u4();
        int numParameters = this.reader.u1();
        while (annotations.size() < numParameters) {
            annotations.add((ImmutableList.Builder<ClassFile.AnnotationInfo>)ImmutableList.builder());
        }
        for (int i = 0; i < numParameters; ++i) {
            int numAnnotations = this.reader.u2();
            for (int n = 0; n < numAnnotations; ++n) {
                annotations.get(i).add((Object)this.readAnnotation(constantPool));
            }
        }
    }

    private void readMethodParameters(ImmutableList.Builder<ClassFile.MethodInfo.ParameterInfo> parameters, ConstantPoolReader constantPool) {
        this.reader.u4();
        int numParameters = this.reader.u1();
        for (int i = 0; i < numParameters; ++i) {
            String name = constantPool.utf8(this.reader.u2());
            int access = this.reader.u2();
            parameters.add((Object)new ClassFile.MethodInfo.ParameterInfo(name, access));
        }
    }

    private ClassFile.ModuleInfo readModule(ConstantPoolReader constantPool) {
        this.reader.u4();
        String name = constantPool.moduleInfo(this.reader.u2());
        int flags = this.reader.u2();
        int versionIndex = this.reader.u2();
        String version = versionIndex != 0 ? constantPool.utf8(versionIndex) : null;
        ImmutableList.Builder requires = ImmutableList.builder();
        int numRequires = this.reader.u2();
        for (int i = 0; i < numRequires; ++i) {
            String requiresModule = constantPool.moduleInfo(this.reader.u2());
            int requiresFlags = this.reader.u2();
            int requiresVersionIndex = this.reader.u2();
            String requiresVersion = requiresVersionIndex != 0 ? constantPool.utf8(requiresVersionIndex) : null;
            requires.add((Object)new ClassFile.ModuleInfo.RequireInfo(requiresModule, requiresFlags, requiresVersion));
        }
        ImmutableList.Builder exports = ImmutableList.builder();
        int numExports = this.reader.u2();
        for (int i = 0; i < numExports; ++i) {
            String exportsModule = constantPool.packageInfo(this.reader.u2());
            int exportsFlags = this.reader.u2();
            int numExportsTo = this.reader.u2();
            ImmutableList.Builder exportsToModules = ImmutableList.builder();
            for (int n = 0; n < numExportsTo; ++n) {
                String exportsToModule = constantPool.moduleInfo(this.reader.u2());
                exportsToModules.add((Object)exportsToModule);
            }
            exports.add((Object)new ClassFile.ModuleInfo.ExportInfo(exportsModule, exportsFlags, (ImmutableList<String>)exportsToModules.build()));
        }
        ImmutableList.Builder opens = ImmutableList.builder();
        int numOpens = this.reader.u2();
        for (int i = 0; i < numOpens; ++i) {
            String opensModule = constantPool.packageInfo(this.reader.u2());
            int opensFlags = this.reader.u2();
            int numOpensTo = this.reader.u2();
            ImmutableList.Builder opensToModules = ImmutableList.builder();
            for (int n = 0; n < numOpensTo; ++n) {
                String opensToModule = constantPool.moduleInfo(this.reader.u2());
                opensToModules.add((Object)opensToModule);
            }
            opens.add((Object)new ClassFile.ModuleInfo.OpenInfo(opensModule, opensFlags, (ImmutableList<String>)opensToModules.build()));
        }
        ImmutableList.Builder uses = ImmutableList.builder();
        int numUses = this.reader.u2();
        for (int i = 0; i < numUses; ++i) {
            String use = constantPool.classInfo(this.reader.u2());
            uses.add((Object)new ClassFile.ModuleInfo.UseInfo(use));
        }
        ImmutableList.Builder provides = ImmutableList.builder();
        int numProvides = this.reader.u2();
        for (int i = 0; i < numProvides; ++i) {
            String typeName = constantPool.classInfo(this.reader.u2());
            int numProvidesWith = this.reader.u2();
            ImmutableList.Builder impls = ImmutableList.builder();
            for (int n = 0; n < numProvidesWith; ++n) {
                String impl = constantPool.classInfo(this.reader.u2());
                impls.add((Object)impl);
            }
            provides.add((Object)new ClassFile.ModuleInfo.ProvideInfo(typeName, (ImmutableList<String>)impls.build()));
        }
        return new ClassFile.ModuleInfo(name, flags, version, (ImmutableList<ClassFile.ModuleInfo.RequireInfo>)requires.build(), (ImmutableList<ClassFile.ModuleInfo.ExportInfo>)exports.build(), (ImmutableList<ClassFile.ModuleInfo.OpenInfo>)opens.build(), (ImmutableList<ClassFile.ModuleInfo.UseInfo>)uses.build(), (ImmutableList<ClassFile.ModuleInfo.ProvideInfo>)provides.build());
    }

    private ClassFile.AnnotationInfo readAnnotation(ConstantPoolReader constantPool) {
        int typeIndex = this.reader.u2();
        String annotationType = constantPool.utf8(typeIndex);
        int numElementValuePairs = this.reader.u2();
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (int e = 0; e < numElementValuePairs; ++e) {
            int elementNameIndex = this.reader.u2();
            String key = constantPool.utf8(elementNameIndex);
            ClassFile.AnnotationInfo.ElementValue value = this.readElementValue(constantPool);
            values.put((Object)key, (Object)value);
        }
        return new ClassFile.AnnotationInfo(annotationType, false, (Map<String, ClassFile.AnnotationInfo.ElementValue>)values.build());
    }

    private ClassFile.AnnotationInfo.ElementValue readElementValue(ConstantPoolReader constantPool) {
        int tag = this.reader.u1();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                int constValueIndex = this.reader.u2();
                return new ClassFile.AnnotationInfo.ElementValue.ConstValue(constantPool.constant(constValueIndex));
            }
            case 101: {
                int typeNameIndex = this.reader.u2();
                int constNameIndex = this.reader.u2();
                String typeName = constantPool.utf8(typeNameIndex);
                String constName = constantPool.utf8(constNameIndex);
                return new ClassFile.AnnotationInfo.ElementValue.EnumConstValue(typeName, constName);
            }
            case 99: {
                int classInfoIndex = this.reader.u2();
                String className = constantPool.utf8(classInfoIndex);
                return new ClassFile.AnnotationInfo.ElementValue.ConstClassValue(className);
            }
            case 64: {
                return new ClassFile.AnnotationInfo.ElementValue.AnnotationValue(this.readAnnotation(constantPool));
            }
            case 91: {
                int numValues = this.reader.u2();
                ImmutableList.Builder elements = ImmutableList.builder();
                for (int i = 0; i < numValues; ++i) {
                    elements.add((Object)this.readElementValue(constantPool));
                }
                return new ClassFile.AnnotationInfo.ElementValue.ArrayValue((List<ClassFile.AnnotationInfo.ElementValue>)elements.build());
            }
        }
        throw new AssertionError((Object)String.format("bad tag value %c", tag));
    }

    private List<ClassFile.MethodInfo> readMethods(ConstantPoolReader constantPool) {
        int methodsCount = this.reader.u2();
        ArrayList<ClassFile.MethodInfo> methods = new ArrayList<ClassFile.MethodInfo>();
        for (int i = 0; i < methodsCount; ++i) {
            int accessFlags = this.reader.u2();
            int nameIndex = this.reader.u2();
            String name = constantPool.utf8(nameIndex);
            int descriptorIndex = this.reader.u2();
            String desc = constantPool.utf8(descriptorIndex);
            int attributesCount = this.reader.u2();
            String signature = null;
            ImmutableList<String> exceptions = ImmutableList.of();
            ImmutableList.Builder annotations = ImmutableList.builder();
            ArrayList<ImmutableList.Builder<ClassFile.AnnotationInfo>> parameterAnnotationsBuilder = new ArrayList<ImmutableList.Builder<ClassFile.AnnotationInfo>>();
            ImmutableList.Builder parameters = ImmutableList.builder();
            ClassFile.AnnotationInfo.ElementValue defaultValue = null;
            block19: for (int j = 0; j < attributesCount; ++j) {
                String attributeName;
                switch (attributeName = constantPool.utf8(this.reader.u2())) {
                    case "Exceptions": {
                        exceptions = this.readExceptions(constantPool);
                        continue block19;
                    }
                    case "Signature": {
                        signature = this.readSignature(constantPool);
                        continue block19;
                    }
                    case "AnnotationDefault": {
                        this.reader.u4();
                        defaultValue = this.readElementValue(constantPool);
                        continue block19;
                    }
                    case "RuntimeInvisibleAnnotations": 
                    case "RuntimeVisibleAnnotations": {
                        this.readAnnotations((ImmutableList.Builder<ClassFile.AnnotationInfo>)annotations, constantPool);
                        continue block19;
                    }
                    case "RuntimeInvisibleParameterAnnotations": 
                    case "RuntimeVisibleParameterAnnotations": {
                        this.readParameterAnnotations(parameterAnnotationsBuilder, constantPool);
                        continue block19;
                    }
                    case "MethodParameters": {
                        this.readMethodParameters((ImmutableList.Builder<ClassFile.MethodInfo.ParameterInfo>)parameters, constantPool);
                        continue block19;
                    }
                    default: {
                        this.reader.skip(this.reader.u4());
                    }
                }
            }
            ImmutableList.Builder parameterAnnotations = ImmutableList.builder();
            for (ImmutableList.Builder builder : parameterAnnotationsBuilder) {
                parameterAnnotations.add((Object)builder.build());
            }
            methods.add(new ClassFile.MethodInfo(accessFlags, name, desc, signature, (List<String>)exceptions, defaultValue, (List<ClassFile.AnnotationInfo>)annotations.build(), (ImmutableList<ImmutableList<ClassFile.AnnotationInfo>>)parameterAnnotations.build(), (ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.of(), (ImmutableList<ClassFile.MethodInfo.ParameterInfo>)parameters.build()));
        }
        return methods;
    }

    private ImmutableList<String> readExceptions(ConstantPoolReader constantPool) {
        ImmutableList.Builder exceptions = ImmutableList.builder();
        this.reader.u4();
        int numberOfExceptions = this.reader.u2();
        for (int exceptionIndex = 0; exceptionIndex < numberOfExceptions; ++exceptionIndex) {
            exceptions.add((Object)constantPool.classInfo(this.reader.u2()));
        }
        return exceptions.build();
    }

    private List<ClassFile.FieldInfo> readFields(ConstantPoolReader constantPool) {
        int fieldsCount = this.reader.u2();
        ArrayList<ClassFile.FieldInfo> fields = new ArrayList<ClassFile.FieldInfo>();
        for (int i = 0; i < fieldsCount; ++i) {
            int accessFlags = this.reader.u2();
            int nameIndex = this.reader.u2();
            String name = constantPool.utf8(nameIndex);
            int descriptorIndex = this.reader.u2();
            String desc = constantPool.utf8(descriptorIndex);
            int attributesCount = this.reader.u2();
            Const.Value value = null;
            block7: for (int j = 0; j < attributesCount; ++j) {
                String attributeName;
                switch (attributeName = constantPool.utf8(this.reader.u2())) {
                    case "ConstantValue": {
                        this.reader.u4();
                        value = constantPool.constant(this.reader.u2());
                        continue block7;
                    }
                    default: {
                        this.reader.skip(this.reader.u4());
                    }
                }
            }
            fields.add(new ClassFile.FieldInfo(accessFlags, name, desc, null, value, (List<ClassFile.AnnotationInfo>)ImmutableList.of(), (ImmutableList<ClassFile.TypeAnnotationInfo>)ImmutableList.of()));
        }
        return fields;
    }
}

