/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

public enum UnaryOperator {
    BINARY_NOT("~", false),
    LOGICAL_NOT("!", false),
    UNARY_PLUS("+", false),
    UNARY_MINUS("-", false),
    PREFIX_INCREMENT("++", false),
    PREFIX_DECREMENT("--", false),
    POSTFIX_INCREMENT("++", true),
    POSTFIX_DECREMENT("--", true);

    private final String symbol;
    private final boolean postfix;

    private UnaryOperator(String symbol, boolean postfix) {
        this.symbol = symbol;
        this.postfix = postfix;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public static UnaryOperator fromSymbol(String symbol, boolean postfix) {
        for (UnaryOperator op : UnaryOperator.values()) {
            if (!op.symbol.equals(symbol) || op.postfix != postfix) continue;
            return op;
        }
        return null;
    }
}

