/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.backend.system;

import com.google.common.flogger.backend.LoggerBackend;
import com.google.common.flogger.backend.Platform;
import com.google.common.flogger.backend.Tags;
import com.google.common.flogger.backend.system.BackendFactory;
import com.google.common.flogger.backend.system.Clock;
import com.google.common.flogger.backend.system.EmptyLoggingContext;
import com.google.common.flogger.backend.system.LoggingContext;
import com.google.common.flogger.backend.system.SimpleBackendFactory;
import com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.common.flogger.backend.system.SystemClock;
import com.google.common.flogger.util.Checks;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "backend_factory";
    private static final String LOGGING_CONTEXT = "logging_context";
    private static final String CLOCK = "clock";
    private final BackendFactory backendFactory;
    private final LoggingContext context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory factory = DefaultPlatform.resolveAttribute(BACKEND_FACTORY, BackendFactory.class);
        this.backendFactory = factory != null ? factory : SimpleBackendFactory.getInstance();
        LoggingContext context = DefaultPlatform.resolveAttribute(LOGGING_CONTEXT, LoggingContext.class);
        this.context = context != null ? context : EmptyLoggingContext.getInstance();
        Clock clock = DefaultPlatform.resolveAttribute(CLOCK, Clock.class);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    DefaultPlatform(BackendFactory factory, LoggingContext context, Clock clock, Platform.LogCallerFinder callerFinder) {
        this.backendFactory = factory;
        this.context = context;
        this.clock = clock;
        this.callerFinder = callerFinder;
    }

    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    protected String getConfigInfoImpl() {
        return "Platform: " + ((Object)((Object)this)).getClass().getName() + "\nBackendFactory: " + this.backendFactory + "\nClock: " + this.clock + "\nLoggingContext: " + this.context + "\nLogCallerFinder: " + this.callerFinder + "\n";
    }

    @Nullable
    private static <T> T resolveAttribute(String attributeName, Class<T> type) {
        String getter = DefaultPlatform.readProperty(attributeName);
        if (getter == null) {
            return null;
        }
        int idx = getter.indexOf(35);
        if (idx <= 0 || idx == getter.length() - 1) {
            DefaultPlatform.error("invalid getter (expected <class>#<method>): %s\n", getter);
            return null;
        }
        return DefaultPlatform.callStaticMethod(getter.substring(0, idx), getter.substring(idx + 1), type);
    }

    private static String readProperty(String attributeName) {
        Checks.checkNotNull((Object)attributeName, (String)"attribute name");
        String propertyName = "flogger." + attributeName;
        try {
            return System.getProperty(propertyName);
        }
        catch (SecurityException e) {
            DefaultPlatform.error("cannot read property name %s: %s", propertyName, e);
            return null;
        }
    }

    private static <T> T callStaticMethod(String className, String methodName, Class<T> type) {
        try {
            return type.cast(Class.forName(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException e) {
            DefaultPlatform.error("cannot cast result of calling '%s#%s' to '%s': %s\n", className, methodName, type.getName(), e);
        }
        catch (Exception e) {
            DefaultPlatform.error("cannot call expected no-argument static method '%s#%s': %s\n", className, methodName, e);
        }
        return null;
    }

    private static void error(String msg, Object ... args) {
        System.err.println(DefaultPlatform.class + ": " + String.format(msg, args));
    }
}

