/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class CaseNode
extends Node {
    protected final CaseTree tree;
    protected final Node switchExpr;
    protected final Node caseExpr;

    public CaseNode(CaseTree tree, Node switchExpr, Node caseExpr, Types types) {
        super(types.getNoType(TypeKind.NONE));
        assert (tree.getKind().equals((Object)Tree.Kind.CASE));
        this.tree = tree;
        this.switchExpr = switchExpr;
        this.caseExpr = caseExpr;
    }

    public Node getSwitchOperand() {
        return this.switchExpr;
    }

    public Node getCaseOperand() {
        return this.caseExpr;
    }

    @Override
    public CaseTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitCase(this, p);
    }

    public String toString() {
        return "case " + this.getCaseOperand() + ":";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CaseNode)) {
            return false;
        }
        CaseNode other = (CaseNode)obj;
        return this.getSwitchOperand().equals(other.getSwitchOperand()) && this.getCaseOperand().equals(other.getCaseOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getSwitchOperand(), this.getCaseOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(2);
        list.add(this.getSwitchOperand());
        list.add(this.getCaseOperand());
        return list;
    }
}

