/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(name="LambdaFunctionalInterface", summary="Use Java's utility functional interfaces instead of Function<A, B> for primitive types.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class LambdaFunctionalInterface
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String JAVA_UTIL_FUNCTION_FUNCTION = "java.util.function.Function";
    private static final String JAVA_LANG_NUMBER = "java.lang.Number";
    private static final ImmutableMap<String, String> methodMappings = ImmutableMap.builder().put((Object)"java.util.function.Function<java.lang.Double,java.lang.Double>", (Object)"java.util.function.DoubleFunction<Double>").put((Object)"java.util.function.Function<java.lang.Double,java.lang.Integer>", (Object)"java.util.function.DoubleToIntFunction").put((Object)"java.util.function.Function<java.lang.Double,java.lang.Long>", (Object)"java.util.function.DoubleToLongFunction").put((Object)"java.util.function.Function<java.lang.Double,T>", (Object)"java.util.function.DoubleFunction<T>").put((Object)"java.util.function.Function<java.lang.Integer,java.lang.Integer>", (Object)"java.util.function.IntFunction<Integer>").put((Object)"java.util.function.Function<java.lang.Integer,java.lang.Double>", (Object)"java.util.function.IntToDoubleFunction").put((Object)"java.util.function.Function<java.lang.Integer,java.lang.Long>", (Object)"java.util.function.IntToLongFunction").put((Object)"java.util.function.Function<java.lang.Integer,T>", (Object)"java.util.function.IntFunction<T>").put((Object)"java.util.function.Function<java.lang.Long,java.lang.Long>", (Object)"java.util.function.LongFunction<Long>").put((Object)"java.util.function.Function<java.lang.Long,java.lang.Integer>", (Object)"java.util.function.LongToIntFunction").put((Object)"java.util.function.Function<java.lang.Long,java.lang.Double>", (Object)"java.util.function.LongToDoubleFunction").put((Object)"java.util.function.Function<java.lang.Long,T>", (Object)"java.util.function.LongFunction<T>").put((Object)"java.util.function.Function<T,java.lang.Long>", (Object)"java.util.function.ToLongFunction<T>").put((Object)"java.util.function.Function<T,java.lang.Integer>", (Object)"java.util.function.ToIntFunction<T>").put((Object)"java.util.function.Function<T,java.lang.Double>", (Object)"java.util.function.ToDoubleFunction<T>").build();
    private static final ImmutableMap<String, String> applyMappings = ImmutableMap.builder().put((Object)"java.util.function.DoubleToIntFunction", (Object)"applyAsInt").put((Object)"java.util.function.DoubleToLongFunction", (Object)"applyAsLong").put((Object)"java.util.function.IntToDoubleFunction", (Object)"applyAsDouble").put((Object)"java.util.function.IntToLongFunction", (Object)"applyAsLong").put((Object)"java.util.function.LongToIntFunction", (Object)"applyAsInt").put((Object)"java.util.function.LongToDoubleFunction", (Object)"applyAsDouble").put((Object)"java.util.function.ToIntFunction<T>", (Object)"applyAsInt").put((Object)"java.util.function.ToDoubleFunction<T>", (Object)"applyAsDouble").put((Object)"java.util.function.ToLongFunction<T>", (Object)"applyAsLong").build();

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol((MethodTree)tree);
        if (!methodSym.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Description.NO_MATCH;
        }
        ImmutableList params = (ImmutableList)tree.getParameters().stream().filter(param -> LambdaFunctionalInterface.hasFunctionAsArg(param, state)).filter(param -> LambdaFunctionalInterface.isFunctionArgSubtypeOf(param, 0, state.getTypeFromString(JAVA_LANG_NUMBER), state) || LambdaFunctionalInterface.isFunctionArgSubtypeOf(param, 1, state.getTypeFromString(JAVA_LANG_NUMBER), state)).collect(ImmutableList.toImmutableList());
        if (params.isEmpty() || !this.methodCallsMeetConditions(methodSym, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        for (Tree param2 : params) {
            LambdaFunctionalInterface.getMappingForFunctionFromTree(param2).ifPresent(mappedFunction -> {
                fixBuilder.addImport(LambdaFunctionalInterface.getImportName(mappedFunction));
                fixBuilder.replace(param2, LambdaFunctionalInterface.getFunctionName(mappedFunction) + " " + ASTHelpers.getSymbol((Tree)param).name);
                this.refactorInternalApplyMethods(tree, fixBuilder, param2, (String)mappedFunction);
            });
        }
        return this.describeMatch(tree, (Fix)fixBuilder.build());
    }

    private void refactorInternalApplyMethods(MethodTree tree, final SuggestedFix.Builder fixBuilder, final Tree param, String mappedFunction) {
        LambdaFunctionalInterface.getMappingForApply(mappedFunction).ifPresent(apply -> tree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                Symbol receiverSym;
                if (ASTHelpers.getSymbol((MethodInvocationTree)callTree).name.contentEquals("apply") && (receiverSym = ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)callTree))) != null && receiverSym.equals(ASTHelpers.getSymbol((Tree)param))) {
                    fixBuilder.replace((Tree)callTree.getMethodSelect(), receiverSym.name + "." + apply);
                }
                return (Void)super.visitMethodInvocation(callTree, unused);
            }
        }, null));
    }

    private boolean methodCallsMeetConditions(Symbol sym, VisitorState state) {
        ImmutableMultimap<String, MethodInvocationTree> methodCallMap = this.methodCallsForSymbol(sym, LambdaFunctionalInterface.getTopLevelClassTree(state));
        if (methodCallMap.isEmpty()) {
            return true;
        }
        for (MethodInvocationTree methodInvocationTree : methodCallMap.values()) {
            if (!methodInvocationTree.getArguments().stream().filter(a -> Tree.Kind.LAMBDA_EXPRESSION.equals((Object)a.getKind())).filter(a -> LambdaFunctionalInterface.hasFunctionAsArg(a, state)).noneMatch(a -> LambdaFunctionalInterface.isFunctionArgSubtypeOf(a, 0, state.getTypeFromString(JAVA_LANG_NUMBER), state) || LambdaFunctionalInterface.isFunctionArgSubtypeOf(a, 1, state.getTypeFromString(JAVA_LANG_NUMBER), state))) continue;
            return false;
        }
        return true;
    }

    private static ClassTree getTopLevelClassTree(VisitorState state) {
        return (ClassTree)Streams.findLast(Streams.stream(state.getPath().iterator()).filter(t -> t.getKind() == Tree.Kind.CLASS)).orElseThrow(() -> new IllegalArgumentException("No enclosing class found"));
    }

    private ImmutableMultimap<String, MethodInvocationTree> methodCallsForSymbol(final Symbol sym, ClassTree classTree) {
        final ImmutableMultimap.Builder methodMap = ImmutableMultimap.builder();
        classTree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree callTree, Void unused) {
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)callTree);
                if (methodSymbol != null && sym.equals(methodSymbol)) {
                    methodMap.put((Object)methodSymbol.toString(), (Object)callTree);
                }
                return (Void)super.visitMethodInvocation(callTree, unused);
            }
        }, null);
        return methodMap.build();
    }

    private static boolean hasFunctionAsArg(Tree param, VisitorState state) {
        return ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)param), (Type)state.getTypeFromString(JAVA_UTIL_FUNCTION_FUNCTION), (VisitorState)state);
    }

    private static boolean isFunctionArgSubtypeOf(Tree param, int argIndex, Type type, VisitorState state) {
        return ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)param).getTypeArguments().get(argIndex), (Type)type, (VisitorState)state);
    }

    private static Optional<String> getMappingForFunctionFromTree(Tree param) {
        Optional<Type> type = Optional.ofNullable(ASTHelpers.getType((Tree)param));
        return type == null ? Optional.empty() : LambdaFunctionalInterface.getMappingForFunction(type.get().toString());
    }

    private static Optional<String> getMappingForFunction(String function) {
        return Optional.ofNullable(methodMappings.get((Object)function));
    }

    private static Optional<String> getMappingForApply(String apply) {
        return Optional.ofNullable(applyMappings.get((Object)apply));
    }

    private static String getFunctionName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
    }

    private static String getImportName(String fullyQualifiedName) {
        int cutPosition = fullyQualifiedName.indexOf(60);
        return cutPosition < 0 ? fullyQualifiedName : fullyQualifiedName.substring(0, cutPosition);
    }
}

