/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.collect.Streams;
import com.google.errorprone.bugpatterns.argumentselectiondefects.AutoValue_NamedParameterComment_MatchedComment;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.Comments;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class NamedParameterComment {
    public static final Pattern PARAMETER_COMMENT_PATTERN = Pattern.compile("\\s*([\\w\\d_]+)\\s*=\\s*");
    private static final String PARAMETER_COMMENT_MARKER = "=";
    private static final Pattern SYNTHETIC_PARAMETER_NAME = Pattern.compile("(arg|this\\$|x)[0-9]+");

    private static boolean isApproximateMatchingComment(Tokens.Comment comment, String formal) {
        switch (comment.getStyle()) {
            case BLOCK: 
            case LINE: {
                String commentText = Comments.getTextFromComment((Tokens.Comment)comment);
                boolean textMatches = Arrays.asList(commentText.split("[^a-zA-Z0-9_]+", -1)).contains(formal);
                boolean tooLong = commentText.length() > formal.length() + 5 && commentText.length() > 50;
                boolean tooMuchMarkup = CharMatcher.anyOf((CharSequence)"-*!@<>").countIn((CharSequence)commentText) > 5;
                return textMatches && !tooLong && !tooMuchMarkup;
            }
        }
        return false;
    }

    static MatchedComment match(Commented<ExpressionTree> actual, String formal) {
        Matcher m;
        Optional lastBlockComment = Streams.findLast(actual.beforeComments().stream().filter(c -> c.getStyle() == Tokens.Comment.CommentStyle.BLOCK));
        if (lastBlockComment.isPresent() && (m = PARAMETER_COMMENT_PATTERN.matcher(Comments.getTextFromComment((Tokens.Comment)((Tokens.Comment)lastBlockComment.get())))).matches()) {
            return MatchedComment.create((Tokens.Comment)lastBlockComment.get(), m.group(1).equals(formal) ? MatchType.EXACT_MATCH : MatchType.BAD_MATCH);
        }
        Optional<Tokens.Comment> approximateMatchComment = Stream.concat(actual.beforeComments().stream(), actual.afterComments().stream()).filter(comment -> NamedParameterComment.isApproximateMatchingComment(comment, formal)).findFirst();
        if (approximateMatchComment.isPresent()) {
            String text;
            return MatchedComment.create(approximateMatchComment.get(), (text = CharMatcher.anyOf((CharSequence)"=:").trimTrailingFrom((CharSequence)Comments.getTextFromComment((Tokens.Comment)approximateMatchComment.get()).trim())).equals(formal) ? MatchType.EXACT_MATCH : MatchType.APPROXIMATE_MATCH);
        }
        return MatchedComment.notAnnotated();
    }

    static String toCommentText(String formal) {
        return String.format("/* %s%s */", formal, PARAMETER_COMMENT_MARKER);
    }

    public static boolean containsSyntheticParameterName(Symbol.MethodSymbol sym) {
        return sym.getParameters().stream().anyMatch(p -> SYNTHETIC_PARAMETER_NAME.matcher(p.getSimpleName()).matches());
    }

    private NamedParameterComment() {
    }

    @AutoValue
    static abstract class MatchedComment {
        MatchedComment() {
        }

        abstract Tokens.Comment comment();

        abstract MatchType matchType();

        static MatchedComment create(Tokens.Comment comment, MatchType matchType) {
            return new AutoValue_NamedParameterComment_MatchedComment(comment, matchType);
        }

        static MatchedComment notAnnotated() {
            return new AutoValue_NamedParameterComment_MatchedComment(new Tokens.Comment(){

                @Override
                public String getText() {
                    throw new IllegalArgumentException("Attempt to call getText on comment when in NOT_ANNOTATED state");
                }

                @Override
                public int getSourcePos(int i) {
                    throw new IllegalArgumentException("Attempt to call getText on comment when in NOT_ANNOTATED state");
                }

                @Override
                public Tokens.Comment.CommentStyle getStyle() {
                    throw new IllegalArgumentException("Attempt to call getText on comment when in NOT_ANNOTATED state");
                }

                @Override
                public boolean isDeprecated() {
                    throw new IllegalArgumentException("Attempt to call getText on comment when in NOT_ANNOTATED state");
                }
            }, MatchType.NOT_ANNOTATED);
        }
    }

    static enum MatchType {
        EXACT_MATCH,
        BAD_MATCH,
        APPROXIMATE_MATCH,
        NOT_ANNOTATED;

    }
}

