/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.map.impl.client.AbstractMapAddEntryListenerRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.io.IOException;

public class MapAddEntryListenerSqlRequest
extends AbstractMapAddEntryListenerRequest {
    private String predicate;
    private transient Predicate cachedPredicate;

    public MapAddEntryListenerSqlRequest() {
    }

    public MapAddEntryListenerSqlRequest(String name, boolean includeValue, int listenerFlags) {
        super(name, includeValue, listenerFlags);
    }

    public MapAddEntryListenerSqlRequest(String name, Data key, boolean includeValue, int listenerFlags) {
        super(name, key, includeValue, listenerFlags);
    }

    public MapAddEntryListenerSqlRequest(String name, Data key, boolean includeValue, String predicate, int listenerFlags) {
        super(name, key, includeValue, listenerFlags);
        this.predicate = predicate;
    }

    @Override
    protected Predicate getPredicate() {
        if (this.cachedPredicate == null && this.predicate != null) {
            this.cachedPredicate = new SqlPredicate(this.predicate);
        }
        return this.cachedPredicate;
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        boolean hasKey = this.key != null;
        writer.writeUTF("name", this.name);
        writer.writeBoolean("i", this.includeValue);
        writer.writeBoolean("key", hasKey);
        writer.writeInt("lf", this.listenerFlags);
        if (this.predicate == null) {
            writer.writeBoolean("pre", false);
            if (hasKey) {
                ObjectDataOutput out = writer.getRawDataOutput();
                out.writeData(this.key);
            }
        } else {
            writer.writeBoolean("pre", true);
            writer.writeUTF("p", this.predicate);
            ObjectDataOutput out = writer.getRawDataOutput();
            if (hasKey) {
                out.writeData(this.key);
            }
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("name");
        this.includeValue = reader.readBoolean("i");
        boolean hasKey = reader.readBoolean("key");
        this.listenerFlags = reader.readInt("lf");
        if (reader.readBoolean("pre")) {
            this.predicate = reader.readUTF("p");
            ObjectDataInput in = reader.getRawDataInput();
            if (hasKey) {
                this.key = in.readData();
            }
        } else if (hasKey) {
            ObjectDataInput in = reader.getRawDataInput();
            this.key = in.readData();
        }
    }
}

