/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public abstract class AbstractExpectedExceptionChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    static final Matcher<StatementTree> MATCHER = Matchers.expressionStatement((Matcher)MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException").withNameMatching(Pattern.compile("expect.*")));
    static final Matcher<ExpressionTree> IS_A = Matchers.staticMethod().onClassAny(new String[]{"org.hamcrest.Matchers", "org.hamcrest.CoreMatchers"}).withSignature("<T>isA(java.lang.Class<T>)");

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        PeekingIterator it = Iterators.peekingIterator(tree.getBody().getStatements().iterator());
        while (it.hasNext() && !MATCHER.matches((Tree)it.peek(), state)) {
            it.next();
        }
        ArrayList<Tree> expectations = new ArrayList<Tree>();
        while (it.hasNext() && MATCHER.matches((Tree)it.peek(), state)) {
            expectations.add((Tree)it.next());
        }
        if (expectations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList<StatementTree> suffix = new ArrayList<StatementTree>();
        Iterators.addAll(suffix, (Iterator)it);
        return this.handleMatch(tree, state, expectations, suffix);
    }

    protected abstract Description handleMatch(MethodTree var1, VisitorState var2, List<Tree> var3, List<StatementTree> var4);

    protected BaseFix buildBaseFix(VisitorState state, List<Tree> expectations) {
        String exceptionClass = "Throwable";
        ArrayList<String> newAsserts = new ArrayList<String>();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        block10: for (Tree expectation : expectations) {
            MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)expectation).getExpression();
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)invocation);
            Symtab symtab = state.getSymtab();
            List<? extends ExpressionTree> args = invocation.getArguments();
            switch (((Name)symbol.getSimpleName()).toString()) {
                case "expect": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)symbol.getParameters())).asType(), (Type)symtab.classType, (VisitorState)state)) {
                        exceptionClass = state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)((ExpressionTree)Iterables.getOnlyElement(args))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown, %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block10;
                }
                case "expectCause": {
                    ExpressionTree matcher = (ExpressionTree)Iterables.getOnlyElement(invocation.getArguments());
                    if (IS_A.matches((Tree)matcher, state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasCauseThat().isInstanceOf(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(((MethodInvocationTree)matcher).getArguments()))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getCause(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block10;
                }
                case "expectMessage": {
                    if (ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)symbol.getParameters())).asType(), (Type)symtab.stringType, (VisitorState)state)) {
                        fix.addStaticImport("com.google.common.truth.Truth.assertThat");
                        newAsserts.add(String.format("assertThat(thrown).hasMessageThat().contains(%s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                        continue block10;
                    }
                    fix.addStaticImport("org.hamcrest.MatcherAssert.assertThat");
                    newAsserts.add(String.format("assertThat(thrown.getMessage(), %s);", state.getSourceForNode((Tree)Iterables.getOnlyElement(args))));
                    continue block10;
                }
            }
            throw new AssertionError((Object)("unknown expect method: " + symbol.getSimpleName()));
        }
        fix.replace(((JCTree)expectations.get(0)).getStartPosition(), state.getEndPosition((Tree)Iterables.getLast(expectations)), "");
        return new BaseFix(fix.build(), exceptionClass, newAsserts);
    }

    protected static class BaseFix {
        final SuggestedFix baseFix;
        final String exceptionClass;
        final List<String> newAsserts;

        BaseFix(SuggestedFix baseFix, String exceptionClass, List<String> newAsserts) {
            this.baseFix = baseFix;
            this.exceptionClass = exceptionClass;
            this.newAsserts = newAsserts;
        }

        public Fix build(List<? extends StatementTree> throwingStatements) {
            boolean useExpressionLambda;
            SuggestedFix.Builder fix = SuggestedFix.builder().merge(this.baseFix);
            StringBuilder fixPrefix = new StringBuilder();
            if (this.newAsserts.isEmpty()) {
                fix.addStaticImport("org.junit.Assert.assertThrows");
                fixPrefix.append("assertThrows");
            } else {
                fix.addStaticImport("org.junit.Assert.expectThrows");
                fixPrefix.append(String.format("%s thrown = expectThrows", this.exceptionClass));
            }
            fixPrefix.append(String.format("(%s.class, () -> ", this.exceptionClass));
            boolean bl = useExpressionLambda = throwingStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(throwingStatements)).getKind() == Tree.Kind.EXPRESSION_STATEMENT;
            if (!useExpressionLambda) {
                fixPrefix.append("{");
            }
            fix.prefixWith((Tree)throwingStatements.get(0), fixPrefix.toString());
            if (useExpressionLambda) {
                fix.postfixWith((Tree)((ExpressionStatementTree)throwingStatements.get(0)).getExpression(), ")");
                fix.postfixWith((Tree)Iterables.getLast(throwingStatements), Joiner.on((char)'\n').join(this.newAsserts));
            } else {
                fix.postfixWith((Tree)Iterables.getLast(throwingStatements), "});\n" + Joiner.on((char)'\n').join(this.newAsserts));
            }
            return fix.build();
        }
    }
}

