/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.Serializable;
import java.util.regex.Pattern;

public abstract class AbstractReturnValueIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FAIL_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.AbstractVerb").named("fail"), MethodMatchers.staticMethod().onClass("org.junit.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("fail")});
    private static final Matcher<ExpressionTree> EXPECT_THROWS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertThrows"), MethodMatchers.staticMethod().onClass("org.junit.Assert").named("expectThrows"), MethodMatchers.staticMethod().onClass("org.junit.jupiter.api.Assertions").named("assertThrows"), MethodMatchers.staticMethod().onClass("org.junit.jupiter.api.Assertions").named("expectThrows")});
    private static final Matcher<StatementTree> EXPECTED_EXCEPTION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.isLastStatementInBlock(), Matchers.enclosingMethod((Matcher)Matchers.contains(ExpressionTree.class, (Matcher)Matchers.methodInvocation((Matcher)MethodMatchers.instanceMethod().onDescendantOf("org.junit.rules.TestRule").withNameMatching(Pattern.compile("expect(Message|Cause)?")))))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.TRY)), Matchers.nextStatement((Matcher)Matchers.expressionStatement(FAIL_METHOD))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.isLastStatementInBlock(), Matchers.enclosingNode((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.METHOD_INVOCATION), Matchers.methodInvocation(EXPECT_THROWS)}))})});
    private static final Matcher<ExpressionTree> MOCKITO_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify"), MethodMatchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when"), MethodMatchers.instanceMethod().onDescendantOf("org.mockito.InOrder").named("verify")});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.EXPRESSION_STATEMENT)), Matchers.not((Matcher)Matchers.methodSelect((Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.IDENTIFIER), AbstractReturnValueIgnored.identifierHasName("super")}))), Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)t), (VisitorState)s)), Matchers.not(AbstractReturnValueIgnored::expectedExceptionTest), this.specializedMatcher()}).matches((Tree)methodInvocationTree, state)) {
            return this.describe(methodInvocationTree, state);
        }
        return Description.NO_MATCH;
    }

    public abstract Matcher<? super MethodInvocationTree> specializedMatcher();

    private static Matcher<ExpressionTree> identifierHasName(final String name) {
        return new Matcher<ExpressionTree>(){

            public boolean matches(ExpressionTree item, VisitorState state) {
                return ((IdentifierTree)item).getName().contentEquals(name);
            }
        };
    }

    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        SuggestedFix fix;
        ExpressionTree identifierExpr = ASTHelpers.getRootAssignable((MethodInvocationTree)methodInvocationTree);
        String identifierStr = null;
        Type identifierType = null;
        if (identifierExpr != null) {
            identifierStr = identifierExpr.toString();
            if (identifierExpr instanceof JCTree.JCIdent) {
                identifierType = ((JCTree.JCIdent)identifierExpr).sym.type;
            } else if (identifierExpr instanceof JCTree.JCFieldAccess) {
                identifierType = ((JCTree.JCFieldAccess)identifierExpr).sym.type;
            } else {
                throw new IllegalStateException("Expected a JCIdent or a JCFieldAccess");
            }
        }
        Type returnType = ASTHelpers.getReturnType((ExpressionTree)((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect());
        if (identifierStr != null && !"this".equals(identifierStr) && returnType != null && state.getTypes().isAssignable(returnType, identifierType)) {
            fix = SuggestedFix.prefixWith((Tree)methodInvocationTree, (String)(identifierStr + " = "));
        } else {
            Tree parent = state.getPath().getParentPath().getLeaf();
            fix = SuggestedFix.delete((Tree)parent);
        }
        return this.describeMatch(methodInvocationTree, (Fix)fix);
    }

    private static boolean expectedExceptionTest(MethodInvocationTree tree, VisitorState state) {
        if (AbstractReturnValueIgnored.mockitoInvocation(tree, state)) {
            return true;
        }
        StatementTree statement = (StatementTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), StatementTree.class);
        return statement != null && EXPECTED_EXCEPTION_MATCHER.matches((Tree)statement, state);
    }

    private static boolean mockitoInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree receiver;
        return tree instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)tree).getMethodSelect() instanceof JCTree.JCFieldAccess && MOCKITO_MATCHER.matches((Tree)(receiver = ASTHelpers.getReceiver((ExpressionTree)tree)), state);
    }
}

