/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.List;

@BugPattern(name="ComparisonOutOfRange", summary="Comparison to value that is out of range for the compared type", explanation="This checker looks for equality comparisons to values that are out of range for the compared type.  For example, bytes may have a value in the range -128 to 127. Comparing a byte for equality with a value outside that range will always evaluate to false and usually indicates an error in the code.\n\nThis checker currently supports checking for bad byte and character comparisons.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ComparisonOutOfRange
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final String MESSAGE_TEMPLATE = "%ss may have a value in the range %d to %d; therefore, this comparison to %s will always evaluate to %s";
    private static final Matcher<BinaryTree> BYTE_MATCHER = new BadComparisonMatcher(Byte.TYPE);
    private static final Matcher<BinaryTree> CHAR_MATCHER = new BadComparisonMatcher(Character.TYPE);

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (Matchers.anyOf((Matcher[])new Matcher[]{BYTE_MATCHER, CHAR_MATCHER}).matches((Tree)tree, state)) {
            return this.describe(tree, state);
        }
        return Description.NO_MATCH;
    }

    public Description describe(BinaryTree tree, VisitorState state) {
        String customDiagnosticMessage;
        SuggestedFix fix;
        boolean willEvaluateTo;
        List binaryTreeMatches = ASTHelpers.matchBinaryTree((BinaryTree)tree, Arrays.asList(Matchers.isInstance(JCTree.JCLiteral.class), Matchers.anything()), (VisitorState)state);
        if (binaryTreeMatches == null) {
            throw new IllegalStateException("Expected one of the operands to be a literal");
        }
        JCTree.JCLiteral literal = (JCTree.JCLiteral)binaryTreeMatches.get(0);
        JCTree nonLiteralOperand = (JCTree)binaryTreeMatches.get(1);
        boolean byteMatch = state.getTypes().isSameType(nonLiteralOperand.type, state.getSymtab().byteType);
        boolean bl = willEvaluateTo = tree.getKind() != Tree.Kind.EQUAL_TO;
        if (byteMatch) {
            String replacement = Byte.toString(((Number)literal.getValue()).byteValue());
            int actualStart = ASTHelpers.getActualStartPosition((JCTree.JCLiteral)literal, (CharSequence)state.getSourceCode());
            fix = actualStart != literal.getStartPosition() ? SuggestedFix.replace((Tree)literal, (String)replacement, (int)(actualStart - literal.getStartPosition()), (int)0) : SuggestedFix.replace((Tree)literal, (String)replacement);
            customDiagnosticMessage = String.format(MESSAGE_TEMPLATE, "byte", -128, 127, literal.toString(), Boolean.toString(willEvaluateTo));
        } else {
            fix = SuggestedFix.replace((Tree)tree, (String)Boolean.toString(willEvaluateTo));
            customDiagnosticMessage = String.format(MESSAGE_TEMPLATE, "char", 0, 65535, literal.toString(), Boolean.toString(willEvaluateTo));
        }
        return this.buildDescription(tree).addFix((Fix)fix).setMessage(customDiagnosticMessage).build();
    }

    private static class BadComparisonMatcher
    implements Matcher<BinaryTree> {
        private final Supplier<Type> comparisonType;
        private final int maxValue;
        private final int minValue;

        public BadComparisonMatcher(Class<?> type) {
            if (type != Byte.TYPE && type != Character.TYPE) {
                throw new IllegalArgumentException("type must be either byte or char, but was " + type.getName());
            }
            if (type == Byte.TYPE) {
                this.comparisonType = Suppliers.BYTE_TYPE;
                this.maxValue = 127;
                this.minValue = -128;
            } else {
                this.comparisonType = Suppliers.CHAR_TYPE;
                this.maxValue = 65535;
                this.minValue = 0;
            }
        }

        public boolean matches(BinaryTree tree, VisitorState state) {
            int intValue;
            if (tree.getKind() != Tree.Kind.EQUAL_TO && tree.getKind() != Tree.Kind.NOT_EQUAL_TO) {
                return false;
            }
            List binaryTreeMatches = ASTHelpers.matchBinaryTree((BinaryTree)tree, Arrays.asList(Matchers.isInstance(JCTree.JCLiteral.class), Matchers.isSameType(this.comparisonType)), (VisitorState)state);
            if (binaryTreeMatches == null) {
                return false;
            }
            JCTree.JCLiteral literal = (JCTree.JCLiteral)binaryTreeMatches.get(0);
            Object literalValue = literal.getValue();
            switch (literal.getKind()) {
                case DOUBLE_LITERAL: {
                    double doubleValue = (Double)literalValue;
                    return doubleValue < (double)this.minValue || doubleValue > (double)this.maxValue;
                }
                case FLOAT_LITERAL: {
                    float floatValue = ((Float)literalValue).floatValue();
                    return floatValue < (float)this.minValue || floatValue > (float)this.maxValue;
                }
                case LONG_LITERAL: {
                    long longValue = (Long)literalValue;
                    return longValue < (long)this.minValue || longValue > (long)this.maxValue;
                }
            }
            if (literalValue instanceof Integer) {
                intValue = (Integer)literalValue;
            } else if (literalValue instanceof Character) {
                intValue = ((Character)literalValue).charValue();
            } else {
                if (literalValue instanceof Boolean) {
                    throw new IllegalStateException("Cannot compare " + this.comparisonType + " to boolean literal");
                }
                throw new IllegalStateException("Unexpected literal type: " + literal);
            }
            return intValue < this.minValue || intValue > this.maxValue;
        }
    }
}

